/*
 *	main.h
 */

#ifndef __MAIN_H
#define __MAIN_H

#include <cufft.h>

#include <sp/spThread.h>
#include <sp/fft.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _spThreadIdListCUFFT
{
    spThreadId id;
    struct _spThreadIdListCUFFT *next;
} *spThreadIdListCUFFT;

typedef struct _spPluginInstanceCUFFT
{
    int version;
    spBool support_double;
    spThreadIdListCUFFT thread_id_list;
} *spPluginInstanceCUFFT;

typedef struct _spFFTRecCUFFT
{
    long fftl;
    long length;
    long batch;
    
    unsigned int gridsize;
    unsigned int blocksize;

    spBool plan_c2c_created;
    spBool plan_r2c_created;
    spBool plan_c2r_created;
    cufftHandle plan_c2c;
    cufftHandle plan_r2c;
    cufftHandle plan_c2r;
    
    cufftComplex *cplx_dataf;
    cufftComplex *dev_cplx_dataf;
    cufftReal *dataf;
    cufftReal *dev_dataf;
    
    cufftDoubleComplex *cplx_data;
    cufftDoubleComplex *dev_cplx_data;
    cufftDoubleReal *data;
    cufftDoubleReal *dev_data;
    
} *spFFTRecCUFFT;

extern void spVectorScalarDivDoubleCUFFT(spFFTRecCUFFT fftrec, double s);
extern void spVectorScalarDivCUFFT(spFFTRecCUFFT fftrec, float s);
extern void spCplxVectorScalarDivDoubleCUFFT(spFFTRecCUFFT fftrec, double s);
extern void spCplxVectorScalarDivCUFFT(spFFTRecCUFFT fftrec, float s);
extern void spRealFFTToPowerDoubleCUFFT(spFFTRecCUFFT fftrec, double exponent);
extern void spRealFFTToPowerCUFFT(spFFTRecCUFFT fftrec, float exponent);
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __MAIN_H */
