/*
 *	base.h
 */

#ifndef SPLIB_BASE_H
#define SPLIB_BASE_H

#include <sp/spBase.h>
#include <sp/spFile.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef round
#define round spRound
#endif
#ifndef fix
#define fix spFix
#endif
#ifndef rem
#define rem spRem
#endif
#ifndef factorial
#define factorial spFactorial
#endif
#ifndef ftos
#define ftos spFtos
#endif
#ifndef nextpow2
#define nextpow2 spNextPow2
#endif

#define setwarningflag spSetWarningFlag
#define spwarning spWarning
#define setmessageflag spSetMessageFlag
#define spmessage spMessage
#define sperror	spError
#define setdebugstdout spSetDebugStdout
#define setdebuglevel spSetDebugLevel
#define spdebug spDebug
#define spprogerror spProgError
				
#if defined(MACOS)
#pragma import on
#endif

extern spBool spSrand(unsigned int seed);
extern void spRandunNoInit(void);
extern float spRandunf(void);
extern float spRandun1f(void);
extern double spRandun(void);
extern double spRandun1(void);
extern void spGaussUseRand(int flag);
extern float spGaussf(float mu, float sigma);
extern double spGauss(double mu, double sigma);
#define spRandnf() spGaussf(0.0f, 1.0f)
#define spRandn() spGauss(0.0, 1.0)
extern long spGcd(long x, long y);
extern void spCExpf(float *xr, float *xi);
extern void spCExp(double *xr, double *xi);
extern void spCLogf(float *xr, float *xi);
extern void spCLog(double *xr, double *xi);
extern void spCLog10f(float *xr, float *xi);
extern void spCLog10(double *xr, double *xi);
extern void spRandSort(void *data, int num, int size);
extern void spDecibel(double *x, long length);
extern void spDecibelp(double *x, long length);

extern spBool spIsIndexBlackKey(int key);
extern spBool spIsIndexWhiteKey(int key);
extern const char *spGetNoteNameFromIndex(int key);
extern int spGetKeyIndex(char *name);
extern int spGetNearestWhiteKeyIndexFromIndex(int key_index, spBool upper);
extern int spGetNearestWhiteKeyIndex(char *name, spBool upper);
extern double spGetNearestWhiteKeyBoundaryCent(int key_index, spBool upper);
extern spBool spIncrementNoteName(char *io_name, int *io_octave_index, int incr);
extern spBool spFreqToNoteName(double freq, int mid_C_octave_index/* 3: SPN/IPN/Roland, 4: YAMAHA/Apple */, char *o_name, int *o_octave_index, double *o_cent);
extern spBool spNoteNameToFreq(char *name, int octave_index, double cent, int mid_C_octave_index/* 3: SPN/IPN/Roland, 4: YAMAHA/Apple */, double *o_freq);

#if defined(MACOS)
#pragma import off
#endif

#define randun_no_init spRandunNoInit
#define randunf spRandunf
#define randun1f spRandun1f
#define randun spRandun
#define randun1 spRandun1
#define gauss_use_rand spGaussUseRand
#define gaussf spGaussf
#define gauss spGauss
#define gcd spGcd 
#define cexpf spCExpf
#define cexp spCExp
#define clogf spCLogf
#define clog spCLog
#define clog10f spCLog10f
#define clog10 spCLog10
#define randsort spRandSort
#define decibel spDecibel
#define decibelp spDecibelp
    
#define randn spRandn
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* SPLIB_BASE_H */
