#include <stdio.h>
#include <math.h>

#include <sp/spLib.h>
#include <sp/spMain.h>

#define FFT_ORDER /*10*//*3*/2
#if 0
#define FFT_BATCH 4
#else
#define FFT_BATCH 1
#endif
#define SIN_NCYCLE 5
#define LENGTH_SHORTEN 10

#define TEST_ANY_LENGTH
#define TEST_ANY_LENGTH_INCREMENT /*13*/3

#undef APPLY_WINDOW

int spMain(int argc, char **argv)
{
    long k, l;
    long order;
    long batch;
    long fftl;
    long fftl_specified;
    spDVector x, y;
    spDVector win;
    spDVector wins;
    spFFTRec fftrec;

#ifdef TEST_ANY_LENGTH
    order = -POW2(FFT_ORDER);
    fprintf(stderr, "---- order = %ld ----\n", order);
#else
    order = FFT_ORDER;
#endif
    batch = FFT_BATCH;
    fftrec = spInitBatchedFFT(order, batch, SP_FFT_DEFAULT_PRECISION);

    for (k = 0; k <= 4; k++) {
        if (k >= 1) {
            spResetFFTOrder(fftrec, order);
        }
        fftl = spGetFFTLength(fftrec);
        fftl_specified = spGetFFTLengthSpecified(fftrec);
        fprintf(stderr, "---- FFTL = %ld (%ld) ----\n", fftl_specified, fftl);

        if (batch <= 1) {
            x = xdvinit(0, 1, fftl_specified - 1);
        } else {
            x = xdvinit(0, 1, batch * fftl - 1);
        }
        dvscoper(x, "*", 2.0 * PI * SIN_NCYCLE / (double)(fftl - MIN(LENGTH_SHORTEN, fftl/4)));
        dvsin(x);
#if 0
        dvdump(x);
#endif
        
#ifdef APPLY_WINDOW
        win = xdvhamming(fftl_specified);
        if (batch >= 2) {
            wins = xdvzeros(x->length);
            for (l = 0; l < batch; l++) {
                /* fftl is OK */
                dvadd(wins, l * fftl, win, 0, win->length, SP_FALSE);
            }
        } else {
            wins = win;
        }
        dvoper(x, "*", wins);
        xdvfree(win);
        if (batch >= 2) {
            xdvfree(wins);
        }
#endif

        y = xdvfftex(fftrec, x);
#if 0
        dvabs(y);
#endif
        dvdump(y);

#if 1
        dvfftshiftbatched(y, fftl_specified, fftl, batch);
        dvdump(y);
        dvifftshiftbatched(y, fftl_specified, fftl, batch);
        dvdump(y);
#endif

        xdvfree(x);
        xdvfree(y);

#ifdef TEST_ANY_LENGTH
        order -= TEST_ANY_LENGTH_INCREMENT;
#else
        ++order;
#endif
    }
    
    spFreeFFT(fftrec);
    
    return 0;
}
