#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include <sp/spLib.h>
#include <sp/spMain.h>

#define WINDOW_LENGTH 8

#if defined(IPHONE) || defined(MACOSX)
#define VECTOR_PLUGIN "vectorAccelerate"
#else
//#undef VECTOR_PLUGIN 
#define VECTOR_PLUGIN "vector_cuda"
#endif

int spMain(int argc, char **argv)
{
    long len;
    spDVector w;
    spPlugin *plugin = NULL;

#ifdef VECTOR_PLUGIN
    fprintf(stderr, "Vector Plugin: %s\n", VECTOR_PLUGIN);
    if ((plugin = spLoadVectorPlugin(VECTOR_PLUGIN)) == NULL) {
        fprintf(stderr, "Cannot load plugin: %s\n", VECTOR_PLUGIN);
    }
#endif

    len = WINDOW_LENGTH;

    printf("hamming window:\n");
    w = xdvhammingul(plugin, len, SP_TRUE);
    dvdump(w);
    xdvfree(w);

    printf("\nhanning window:\n");
    w = xdvhanningul(plugin, len, SP_TRUE);
    dvdump(w);
    xdvfree(w);
    
    printf("\nhann window:\n");
    w = xdvhannul(plugin, len, SP_TRUE);
    dvdump(w);
    xdvfree(w);
    
    printf("\nblackman window:\n");
    w = xdvblackmanul(plugin, len, SP_TRUE);
    dvdump(w);
    xdvfree(w);
    
    printf("\ngauss window:\n");
    w = xdvgausswinul(plugin, len, SP_TRUE);
    dvdump(w);
    xdvfree(w);
    
    printf("\nkaiser window:\n");
    w = xdvkaiserul(plugin, len, 2.5, SP_TRUE);
    dvdump(w);
    xdvfree(w);
    
    return 0;
}

