/*
 *	kaiser.h
 */

#ifndef SPLIB_KAISER_H
#define SPLIB_KAISER_H

#include <sp/vector.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(MACOS)
#pragma import on
#endif

extern float getkaiserparamexf(float sidelobe, float trans, long max_length, float *beta, long *length);
extern double getkaiserparamex(double sidelobe, double trans, long max_length, double *beta, long *length);
extern void getkaiserparamf(float sidelobe, float trans, float *beta, long *length);
extern void getkaiserparam(double sidelobe, double trans, double *beta, long *length);

extern float kaiserordexf(float cutlow, float cuthigh, float devlow, float devhigh, spBool hp_flag,
                          long max_order, long *order, float *cutoff, float *beta);
extern double kaiserordex(double cutlow, double cuthigh, double devlow, double devhigh, spBool hp_flag,
			  long max_order, long *order, double *cutoff, double *beta);
extern void kaiserordf(float cutlow, float cuthigh, float devlow, float devhigh, spBool hp_flag,
                       long *order, float *cutoff, float *beta);
extern void kaiserord(double cutlow, double cuthigh, double devlow, double devhigh, spBool hp_flag,
		      long *order, double *cutoff, double *beta);
    
extern float ai0f(float x);
extern double ai0(double x);
extern int kaiserf(float *w, long n, float beta);
extern int kaiser(double *w, long n, double beta);
extern int nkaiserf(float *w, long n, float beta);
extern int nkaiser(double *w, long n, double beta);

extern void fvkaiser(spFVector vec, float beta);
extern void dvkaiser(spDVector vec, double beta);
extern spFVector xfvkaiserul(spPlugin *plugin, long length, float beta, spBool unlock_flag);
extern spDVector xdvkaiserul(spPlugin *plugin, long length, double beta, spBool unlock_flag);
extern spFVector xfvkaiser(long length, float beta);
extern spDVector xdvkaiser(long length, double beta);

extern void fvnkaiser(spFVector vec, float beta);
extern void dvnkaiser(spDVector vec, double beta);
extern spFVector xfvnkaiserul(spPlugin *plugin, long length, float beta, spBool unlock_flag);
extern spDVector xdvnkaiserul(spPlugin *plugin, long length, double beta, spBool unlock_flag);
extern spFVector xfvnkaiser(long length, float beta);
extern spDVector xdvnkaiser(long length, double beta);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* SPLIB_KAISER_H */
