/*
 *	memory.h
 */

#ifndef SPLIB_MEMORY_H
#define SPLIB_MEMORY_H

#include <sp/spMemory.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef ximatalloc
#define ximatalloc(row, col) xspIMatAlloc((int)(row), (int)(col))
#define xsmatalloc(row, col) xspSMatAlloc((int)(row), (int)(col))
#define xlmatalloc(row, col) xspLMatAlloc((int)(row), (int)(col))
#define xfmatalloc(row, col) xspFMatAlloc((int)(row), (int)(col))
#define xdmatalloc(row, col) xspDMatAlloc((int)(row), (int)(col))

#define ximatfree(x, row) xspIMatFree(x, (int)(row))
#define xsmatfree(x, row) xspSMatFree(x, (int)(row))
#define xlmatfree(x, row) xspLMatFree(x, (int)(row))
#define xfmatfree(x, row) xspFMatFree(x, (int)(row))
#define xdmatfree(x, row) xspDMatFree(x, (int)(row))
#endif

#ifndef ximatalloc
#define xcmatalloc(row, col) xspCMatAlloc((int)(row), (int)(col))
#define xcmatfree(x, row) xspCMatFree(x, (int)(row))
#define xucmatalloc(row, col) xspUCMatAlloc((int)(row), (int)(col))
#define xucmatfree(x, row) xspUCMatFree(x, (int)(row))
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* SPLIB_MEMORY_H */
