/*
 *	sfconv.h
 */

#ifndef SPLIB_SFCONV_H
#define SPLIB_SFCONV_H

#include <sp/vector.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(MACOS)
#pragma import on
#endif

extern void setsfcframe(double framem);
extern void getsfcframe(double *framem);
extern void setsfcparam(double cutoff, double sidelobe, double transition,
			double tolerance, long fftl);
extern void getsfcparam(double *cutoff, double *sidelobe, double *transition,
			double *tolerance, long *fftl);
extern double getsfcratio(double i_samp_freq, double o_samp_freq, double tolerance, 
			  long *upratio, long *downratio);

extern spDVector xdvupsample(spDVector sig, long upratio);
extern spDVector xdvdownsample(spDVector sig, long downratio, long offset, long length);

extern int resamplefile(const char *i_filename, int i_swap, const char *o_filename, int o_swap,
			spDVector filter, long upratio, long downratio);
extern int resampledfile(const char *i_filename, int i_swap, const char *o_filename, int o_swap,
			 spDVector filter, long upratio, long downratio);
extern int sfconvlongfile(const char *i_filename, int i_swap, double i_samp_freq,
			  const char *o_filename, int o_swap, double o_samp_freq);
extern int sfconvlongdfile(const char *i_filename, int i_swap, double i_samp_freq,
			   const char *o_filename, int o_swap, double o_samp_freq);
extern spDVector xdvsfconvfile(const char *i_filename, int swap, double i_samp_freq, double o_samp_freq);
extern spDVector xdvsfconvdfile(const char *i_filename, int swap, double i_samp_freq, double o_samp_freq);
extern spDVector xdvfirresample(long upratio, long downratio, double n);
extern spDVector xdvresample(spDVector isig, spDVector filter, long upratio, long downratio);
extern spDVector xdvsfconv(spDVector isig, double i_samp_freq, double o_samp_freq, double *new_o_samp_freq);
extern int sfconvfile(const char *i_filename, int i_swap, double i_samp_freq,
		      const char *o_filename, int o_swap, double o_samp_freq);
extern int sfconvdfile(const char *i_filename, int i_swap, double i_samp_freq,
		       const char *o_filename, int o_swap, double o_samp_freq);

#define SP_RESAMPLE_VERSION_STRING      "1.0.0"
#define SP_RESAMPLE_VERSION             1
#define SP_RESAMPLE_REVISION            0
#define SP_RESAMPLE_UPDATE_LEVEL        0
#define SP_RESAMPLE_VERSION_ID          (SP_RESAMPLE_VERSION * 1000 + SP_RESAMPLE_REVISION)

typedef struct _spResampleRec *spResampleRec;

#define SP_RESAMPLE_OPTION_FILTER_TYPE_KAISER (1<<0)
#define SP_RESAMPLE_OPTION_FILTER_TYPE_HAMMING (1<<1) /* not supported yet */
#define SP_RESAMPLE_OPTION_FILTER_TYPE_BUTTERWORTH (1<<2) /* not supported yet */
#define SP_RESAMPLE_OPTION_FILTER_TYPE_CHEBYSHEV (1<<3) /* not supported yet */
#define SP_RESAMPLE_OPTION_TRUNCATE_EDGE (1<<8) /* truncate waveform head and tail edge generated by filtering */
#define SP_RESAMPLE_OPTION_INPUT_INTERLEAVED (1<<9)
#define SP_RESAMPLE_OPTION_OUTPUT_INTERLEAVED (1<<10)

typedef struct _spResampleConfig {
    unsigned long version_id;	/* this member is automatically initialized by spResampleInitConfig */

    int num_channel;		/* number of channels; stereo=2, mono=1. default=1 (mono) */
    int input_samp_bit;
    int output_samp_bit;
    
    long max_input_buf_length;

    unsigned long options;
    
    double cutoff;
    double sidelobe;
    double transition;
    double tolerance;
} spResampleConfig;

extern spBool _spResampleInitConfig(spResampleConfig *config, unsigned long version_id);
#define spResampleInitConfig(conf) _spResampleInitConfig(conf, SP_RESAMPLE_VERSION_ID)

extern spResampleRec spResampleOpen(spResampleConfig *config);
extern spBool spResampleClose(spResampleRec resample);
    
extern spBool spResampleSetRatioWithFilter(spResampleRec resample, spDVector filter, long upratio, long downratio,
                                           long *max_output_buf_length, long *default_delay);
extern spBool spResampleSetRatio(spResampleRec resample, long upratio, long downratio,
				 long *max_output_buf_length, long *default_delay);
extern double spResampleCalcRatioFromFrequency(double tolerance, double i_samp_freq, double o_samp_freq,
					       long *upratio, long *downratio);
extern double spResampleSetFrequencyWithFilter(spResampleRec resample, spDVector filter, double i_samp_freq, double o_samp_freq,
                                               long *max_output_buf_length, long *default_delay);
extern double spResampleSetFrequency(spResampleRec resample, double i_samp_freq, double o_samp_freq,
				     long *max_output_buf_length, long *default_delay);
    
extern long spResampleGetNextMaxInputBufferLength(spResampleRec resample, long output_buf_length);
extern long _spResampleProcess(spResampleRec resample, char *input_buf, long input_buf_length, char *output_buf, long *current_delay);
#define spResampleProcess(resample, input_buf, input_buf_length, output_buf, current_delay) _spResampleProcess(resample, (char *)(input_buf), input_buf_length, (char *)(output_buf), current_delay)
    
extern spBool spResampleReset(spResampleRec resample);
extern long _spResampleFlush(spResampleRec resample, char *output_buf);
#define spResampleFlush(resample, output_buf) _spResampleFlush(resample, (char *)output_buf)
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* SPLIB_SFCONV_H */
