/** @file sp/sp.h
 */

#ifndef SPLIB_SP_H
#define SPLIB_SP_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <sp/spDefs.h>
#include <sp/spBase.h>
#include <sp/spOption.h>

#ifdef __cplusplus
extern "C" {
#endif

/** @~english @defgroup spGroup <sp/sp.h>: Basic Definitions
@code
#include <sp/sp.h>
@endcode
 */

/** @addtogroup spGroup
 *  @{ */  /*----@addtogroup spGroup----*/

#define SP_VERSION 		0
#define SP_REVISION		9
#define SP_UPDATE_LEVEL		5
#define SP_VERSION_ID		(SP_VERSION * 1000 + SP_REVISION)
#define SP_VERSION_STRING	"0.9.5"

#if !defined(MACOS9)
#define SP_USE_VECTOR_ENGINE
#endif

#define SP_CHECK_VERSION(version, revision, update) \
    (SP_VERSION > (version) || \
     (SP_VERSION == (version) && SP_REVISION > (revision)) || \
     (SP_VERSION == (version) && SP_REVISION == (revision) && SP_UPDATE_LEVEL >= (update)))

#ifdef DBL_MIN
#define SP_DBL_MIN DBL_MIN
#else
#define SP_DBL_MIN 2.2250738585072014e-308
#endif
#ifdef DBL_MAX
#define SP_DBL_MAX DBL_MAX
#else
#define SP_DBL_MAX 1.7976931348623158e+308
#endif

#ifdef FLT_MIN
#define SP_FLT_MIN FLT_MIN
#else
#define SP_FLT_MIN 1.175494351e-38f
#endif
#ifdef FLT_MAX
#define SP_FLT_MAX FLT_MAX
#else
#define SP_FLT_MAX 3.402823466e+38f
#endif

#ifdef M_LN10
#define SP_LN10		M_LN10
#else
#define SP_LN10		2.30258509299404568402
#endif
    
#ifndef SP_NODATA
#define SP_NODATA 	NULL /**< @~english Means that there is no data for the vector type. */
#endif

#define NODATA SP_NODATA /**< @~english Means that there is no data for the vector type. */

/** @} */  /*----@addtogroup spGroup----*/

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* SPLIB_SP_H */
