/*
 *      spPicola.h
 */

#ifndef SPLIB_SPPICOLA_H
#define SPLIB_SPPICOLA_H

#include <sp/spDefs.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SPPICOLA_VERSION_STRING      "0.9.0"
#define SPPICOLA_VERSION             0
#define SPPICOLA_REVISION            9
#define SPPICOLA_UPDATE_LEVEL        0
#define SPPICOLA_VERSION_ID          (SPPICOLA_VERSION * 1000 + SPPICOLA_REVISION)

typedef struct _spPicola *spPicola;

typedef struct _spPicolaConfig {
    unsigned long version_id;	/* this member is automatically initialized by spPicolaInitConfig */

    double samp_freq;		/* sampling frequency in Hz. default=8000Hz */
    int num_channel;		/* number of channels; stereo=2, mono=1. default=1 (mono) */

    double max_input_buf_length_ms; /* maximum input buffer length per channel in msec. default=20msec */
    double min_period_ms;	/* minimum pitch period for internal processing */
    double max_period_ms;	/* maximum pitch period for internal processing */
} spPicolaConfig;

extern spBool _spPicolaInitConfig(spPicolaConfig *config, unsigned long version_id);
extern spPicola spPicolaOpen(spPicolaConfig *config); /* *config must exist until spPicolaClose */
extern spBool spPicolaSetRate(spPicola picola, double rate, long *max_input_buf_length, long *max_output_buf_length);
extern spBool spPicolaProcess(spPicola picola, 
			      double *input_buf, long *input_buf_length, double *output_buf, long *output_buf_length, long *input_delay);
extern spBool spPicolaFlush(spPicola picola, double *output_buf, long *output_buf_length);
extern spBool spPicolaClose(spPicola picola);
    
#define spPicolaInitConfig(conf) _spPicolaInitConfig(conf, SPPICOLA_VERSION_ID)

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* SPLIB_SPPICOLA_H */
