#include <sp/spDefs.h>
#include <sp/spBase.h>
#include <sp/spMemory.h>
#include <sp/spThread.h>

#include <sp/fftplugin.h>
#include <sp/spPluginMain.h>

typedef struct _spFFTRecOoura
{
    int fftl;

    char *iobuf;
    char *workbuf;
    char *tablebuf;

    int init_flag;
} *spFFTRecOoura;

static spBool spInitOoura(const char *lang)
{
    return SP_TRUE;
}

static spBool spFreeOoura(void)
{
    return SP_TRUE;
}

static void *spInitInstanceOoura(const char *lang)
{
    return (void *)1;		/* dummy */
}

static spBool spFreeInstanceOoura(void *instance)
{
    return SP_TRUE;
}

static spBool spIsPrecisionSupportedOoura(void *instance, spFFTPrecision precision, spFFTSpeed *speed)
{
    if (precision == SP_FFT_DOUBLE_PRECISION) {
	if (speed != NULL) *speed = SP_FFT_SPEED_FASTER;
	return SP_TRUE;
    } else {
	return SP_FALSE;
    }
}

static void *spInitFFTOoura(void *instance, long order, long batch, spFFTPrecision precision)
{
    spFFTRecOoura fftrec;

    fftrec = xalloc(1, struct _spFFTRecOoura);
    memset(fftrec, 0, sizeof(struct _spFFTRecOoura));
    fftrec->fftl = (int)POW2(order);

    fftrec->iobuf = xalloc(fftrec->fftl * 2 * sizeof(double), char);
    fftrec->workbuf = xalloc((3 + (int)spRound(sqrt((double)fftrec->fftl))) * sizeof(int), char);
    fftrec->tablebuf = xalloc(fftrec->fftl * sizeof(double), char);
    fftrec->init_flag = 0;
    
    return fftrec;
}

static spBool spFreeFFTOoura(void *instance, void *ifftrec)
{
    spFFTRecOoura fftrec = (spFFTRecOoura)ifftrec;

    if (fftrec != NULL) {
	if (fftrec->iobuf != NULL) xfree(fftrec->iobuf);
	if (fftrec->workbuf != NULL) xfree(fftrec->workbuf);
	if (fftrec->tablebuf != NULL) xfree(fftrec->tablebuf);
    
	xfree(fftrec);
    }
    
    return SP_TRUE;
}

static spBool spExecFFTFOoura(void *instance, void *ifftrec, float *real, float *imag, int inv)
{
    int k;
    int signval;
    float *iodata;
    float *ip;
    float fftlf;
    spFFTRecOoura fftrec = (spFFTRecOoura)ifftrec;
    void cdftf(int n, int isgn, float *a, int *ip, float *w);

    if (inv) {
	signval = 1;
    } else {
	signval = -1;
    }

    iodata = (float *)fftrec->iobuf;
    
    for (k = 0; k < fftrec->fftl; k++) {
	iodata[2 * k] = real[k];
	iodata[2 * k + 1] = imag[k];
    }

    if (fftrec->init_flag != 1) {
	ip = (float *)fftrec->workbuf;
	ip[0] = 0.0f;
	fftrec->init_flag = 1;
    }

    cdftf(2 * fftrec->fftl, signval, iodata, (int *)fftrec->workbuf, (float *)fftrec->tablebuf);

    if (inv) {
	fftlf = (float)fftrec->fftl;
	for (k = 0; k < fftrec->fftl; k++) {
	    real[k] = iodata[2 * k] / fftlf;
	    imag[k] = iodata[2 * k + 1] / fftlf;
	}
    } else {
	for (k = 0; k < fftrec->fftl; k++) {
	    real[k] = iodata[2 * k];
	    imag[k] = iodata[2 * k + 1];
	}
    }
    
    return SP_TRUE;
}

static spBool spExecFFTOoura(void *instance, void *ifftrec, double *real, double *imag, int inv)
{
    int k;
    int signval;
    double *iodata;
    double *ip;
    double fftlf;
    spFFTRecOoura fftrec = (spFFTRecOoura)ifftrec;
    void cdft(int n, int isgn, double *a, int *ip, double *w);

    if (inv) {
	signval = 1;
    } else {
	signval = -1;
    }

    iodata = (double *)fftrec->iobuf;
    
    for (k = 0; k < fftrec->fftl; k++) {
	iodata[2 * k] = real[k];
	iodata[2 * k + 1] = imag[k];
    }

    if (fftrec->init_flag != 2) {
	ip = (double *)fftrec->workbuf;
	ip[0] = 0.0;
	fftrec->init_flag = 2;
    }

    cdft(2 * fftrec->fftl, signval, iodata, (int *)fftrec->workbuf, (double *)fftrec->tablebuf);

    if (inv) {
	fftlf = (double)fftrec->fftl;
	for (k = 0; k < fftrec->fftl; k++) {
	    real[k] = iodata[2 * k] / fftlf;
	    imag[k] = iodata[2 * k + 1] / fftlf;
	}
    } else {
	for (k = 0; k < fftrec->fftl; k++) {
	    real[k] = iodata[2 * k];
	    imag[k] = iodata[2 * k + 1];
	}
    }
    
    return SP_TRUE;
}

static spBool spExecRealFFTFOoura(void *instance, void *ifftrec, float *data, int inv)
{
    int k;
    int signval;
    int fftl2;
    float *ip;
    float fftlf;
    spFFTRecOoura fftrec = (spFFTRecOoura)ifftrec;
    void rdftf(int n, int isgn, float *a, int *ip, float *w);
    
    if (inv) {
	signval = -1;
	fftl2 = fftrec->fftl / 2;
	for (k = 0; k < fftl2; k++) {
	    data[2 * k + 1] *= -1.0f;
	}
    } else {
	signval = 1;
    }

    if (fftrec->init_flag != 1) {
	ip = (float *)fftrec->workbuf;
	ip[0] = 0.0f;
	fftrec->init_flag = 1;
    }

    rdftf(fftrec->fftl, signval, data, (int *)fftrec->workbuf, (float *)fftrec->tablebuf);
    
    if (inv) {
	fftlf = (float)fftrec->fftl;
	for (k = 0; k < fftrec->fftl; k++) {
	    data[k] *= 2.0f / fftlf;
	}
    } else {
	fftl2 = fftrec->fftl / 2;
	for (k = 0; k < fftl2; k++) {
	    data[2 * k + 1] *= -1.0f;
	}
    }
    
    return SP_TRUE;
}

static spBool spExecRealFFTOoura(void *instance, void *ifftrec, double *data, int inv)
{
    int k;
    int signval;
    int fftl2;
    double *ip;
    double fftlf;
    spFFTRecOoura fftrec = (spFFTRecOoura)ifftrec;
    void rdft(int n, int isgn, double *a, int *ip, double *w);

    if (inv) {
	signval = -1;
	fftl2 = fftrec->fftl / 2;
	for (k = 1; k < fftl2; k++) {
	    data[2 * k + 1] *= -1.0;
	}
    } else {
	signval = 1;
    }

    if (fftrec->init_flag != 2) {
	ip = (double *)fftrec->workbuf;
	ip[0] = 0.0;
	fftrec->init_flag = 2;
    }

    rdft(fftrec->fftl, signval, data, (int *)fftrec->workbuf, (double *)fftrec->tablebuf);
    
    if (inv) {
	fftlf = (double)fftrec->fftl;
	for (k = 0; k < fftrec->fftl; k++) {
	    data[k] *= 2.0 / fftlf;
	}
    } else {
	fftl2 = fftrec->fftl / 2;
	for (k = 1; k < fftl2; k++) {
	    data[2 * k + 1] *= -1.0;
	}
    }
    
    return SP_TRUE;
}

static spFFTPluginRec sp_fft_plugin_ooura = {
    NULL,
    NULL,

    SP_PLUGIN_FFT,
    "oourafft",
    1,
    SP_PLUGIN_PRIORITY_MIDDLE,
    SP_PLUGIN_CAPS_THREAD_SAFE,	/* caps */
    spInitOoura,
    spFreeOoura,
    "OouraFFT",
    "OouraFFT Plugin  Version 0.1",
    
    spInitInstanceOoura,
    spFreeInstanceOoura,
    NULL,
    NULL,

    NULL,
    NULL,
    NULL,
	
    spIsPrecisionSupportedOoura,

    NULL,
    NULL,
	
    spInitFFTOoura,
    spFreeFFTOoura,
    NULL,
	
    spExecFFTFOoura,
    spExecFFTOoura,
	
    spExecRealFFTFOoura,
    spExecRealFFTOoura,
	
    NULL,
    NULL,
};

spPluginExport spPluginRec *spGetPluginRec(void)
{
    return (spPluginRec *)&sp_fft_plugin_ooura;
}

SP_DECLARE_UNIQUE_GET_PLUGIN_REC(oourafft)
