# Copyright (C) 2009 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
LOCAL_PATH := $(call my-dir)

SP_INCLUDE_TOP := ../../../include
SP_BASE_TOP := ../../../spBase

include $(CLEAR_VARS)

LOCAL_MODULE    := libsp
LOCAL_SRC_FILES := \
		../../fileio.c \
		../../base.c \
		../../vector.c \
		../../voperate.c \
		../../vmath.c \
		../../matrix.c \
		../../fft.c \
		../../fftplugin.c \
		../../window.c \
		../../filter.c \
		../../kaiser.c \
		../../sfconv.c \
		../../lpc.c \
		../../spPicola.c \
		../../cqt.c

ifeq ($(TARGET_ARCH_ABI),arm64-v8a)
LOCAL_CFLAGS += -ffast-math
endif
ifeq ($(TARGET_ARCH_ABI),armeabi-v7a)
LOCAL_ARM_MODE  := arm
#LOCAL_ARM_NEON  := false
endif
ifeq ($(TARGET_ARCH_ABI),armeabi-v7a-hard)
LOCAL_ARM_MODE  := arm
LOCAL_ARM_NEON  := true
LOCAL_CFLAGS += -ffast-math
endif

LOCAL_C_INCLUDES := $(LOCAL_PATH)/$(SP_INCLUDE_TOP) $(LOCAL_PATH)/$(SP_BASE_TOP) $(LOCAL_PATH)/../../../spAudio $(LOCAL_PATH)/../../.. 
LOCAL_CFLAGS += -DANDROID -DHAVE_PTHREAD $(LOCAL_C_INCLUDES:%=-I%)

include $(BUILD_STATIC_LIBRARY)
