LOCAL_PATH := $(call my-dir)

SP_INCLUDE_TOP := $(LOCAL_PATH)/../../../../../include
SP_BASE_TOP := $(LOCAL_PATH)/../../../../../spBase
SP_BASE_LIB_LOCAL := $(LOCAL_PATH)/../../../../../spBase/android/obj/local
SP_AUDIO_TOP := $(LOCAL_PATH)/../../../../../spAudio
SP_AUDIO_LIB_LOCAL := $(LOCAL_PATH)/../../../../../spAudio/android/obj/local
SP_TOP := $(LOCAL_PATH)/../../../../..
SP_LIB_LOCAL := $(LOCAL_PATH)/../../../../../sp/android/obj/local

include $(CLEAR_VARS)

LOCAL_MODULE    := mattest
LOCAL_SRC_FILES := mattest.c 

ifeq ($(TARGET_ARCH_ABI),arm64-v8a)
LOCAL_CFLAGS += -ffast-math
endif
ifeq ($(TARGET_ARCH_ABI),armeabi-v7a)
LOCAL_ARM_MODE  := arm
LOCAL_ARM_NEON  := false
endif
ifeq ($(TARGET_ARCH_ABI),armeabi-v7a-hard)
LOCAL_ARM_MODE  := arm
LOCAL_ARM_NEON  := true
LOCAL_CFLAGS += -ffast-math
endif

SP_BASE_LIB_TOP := $(SP_BASE_LIB_LOCAL)/$(TARGET_ARCH_ABI)
SP_AUDIO_LIB_TOP := $(SP_AUDIO_LIB_LOCAL)/$(TARGET_ARCH_ABI)
SP_LIB_TOP := $(SP_LIB_LOCAL)/$(TARGET_ARCH_ABI)

LOCAL_C_INCLUDES := $(SP_INCLUDE_TOP) $(SP_BASE_TOP) $(SP_AUDIO_TOP) $(SP_TOP)
LOCAL_CFLAGS += -DANDROID -DHAVE_PTHREAD $(LOCAL_C_INCLUDES:%=-I%)
LOCAL_LDLIBS := -L$(SP_BASE_LIB_TOP) -L$(SP_AUDIO_LIB_TOP) -L$(SP_LIB_TOP) -L$(SYSROOT)/usr/lib -lsp -lspa -lspb -lOpenSLES -ldl -llog -landroid
ifeq ($(TARGET_ARCH_ABI),armeabi-v7a-hard)
LOCAL_LDLIBS += -lm_hard
endif

LOCAL_STATIC_LIBRARIES := android_native_app_glue

include $(BUILD_SHARED_LIBRARY)

$(call import-module,android/native_app_glue)
