/*
 *	fftP.h
 */

#ifndef SPLIB_FFTP_H
#define SPLIB_FFTP_H

#include <sp/spPlugin.h>
#include <sp/fft.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
    SP_FFT_TYPE_UNKNOWN = -1,
    SP_FFT_TYPE_FLOAT_COMPLEX = 0,
    SP_FFT_TYPE_DOUBLE_COMPLEX,
    SP_FFT_TYPE_FLOAT_REAL,
    SP_FFT_TYPE_DOUBLE_REAL,
} spFFTType;

typedef struct _spFFTThreadRec {
    spFFTRec parent;
    spFFTRec fftrec;

    long index;
    void *event_for_data;
    void *thread;
    
    spFFTType fft_type;
    void *data;
    void *imag;
    int inv;
} spFFTThreadRec;
    
struct _spFFTRec {
    long order;
    long batch;
    long fftl;
    spFFTPrecision precision;
    spFFTSpeed speed;

    spBool support_batch;
    spBool thread_safe;
    volatile spBool terminate_thread;
    long num_thread;
    spFFTThreadRec *thread_recs;

#if defined(MACOSX)
    FFTSetup setup;
    DSPSplitComplex scbuf;
    
    FFTSetupD setupD;
    DSPDoubleSplitComplex scbufD;
#elif defined(USE_SPL)
    double *data;
    
    float *freal;
    float *fimag;
#endif
    
    spPlugin *plugin;
    void *plugin_fftrec;
    
    void *event_for_proc;
    void *mutex;
    volatile long num_computing;

    long fftl_specified;
#ifdef SP_FFT_SUPPORT_BLUESTEIN_ALGORITHM
    /* Bluestein's algorithm */
    spDVector bs_exparg;
    spDVector bs_w;
    spDVector bs_wc;
    spDVector bs_W;
    spDVector bs_W_for_inv;
    spDVector bs_buffer;
#endif
};

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* SPLIB_FFTP_H */
