#include <sp/spBase.h>
#include <sp/spMemory.h>
#include <sp/spPlugin.h>

#if defined(MACOSX)
#if !defined(IPHONE)
#include <CoreServices/CoreServices.h>
#endif
#if defined(IPHONE) || (defined(MAC_OS_X_VERSION_MIN_REQUIRED) && (MAC_OS_X_VERSION_MIN_REQUIRED >= 1060) \
			|| defined(__IPHONE_OS_VERSION_MIN_REQUIRED) && (__IPHONE_OS_VERSION_MIN_REQUIRED >= 50000))
#include <Accelerate/Accelerate.h>
#else
#include <vecLib/vDSP.h>
#endif
#endif

#include <sp/fftP.h>
#include <sp/fftplugin.h>

spBool spInitFFT_Plugin(spFFTRec fftrec)
{
    if (fftrec->plugin->instance == NULL) {
	if (spInitPluginInstance(fftrec->plugin) == SP_FALSE) {
	    return SP_FALSE;
	}
    }
    
    spDebug(80, "spInitFFT_Plugin", "order = %ld, batch = %ld, precision = %d\n",
	    fftrec->order, fftrec->batch, fftrec->precision);
    
    fftrec->plugin_fftrec = SpFFTRecPluginRec(fftrec)->init_fft(fftrec->plugin->instance,
								fftrec->order, fftrec->batch,
								fftrec->precision);

    if (fftrec->plugin_fftrec == NULL) {
	return SP_FALSE;
    } else {
	return SP_TRUE;
    }
}

spBool spFreeFFT_Plugin(spFFTRec fftrec)
{
    if (fftrec->plugin->instance == NULL) return SP_FALSE;
    
    return SpFFTRecPluginRec(fftrec)->free_fft(fftrec->plugin->instance, fftrec->plugin_fftrec);
}

spBool spResetFFTOrder_Plugin(spFFTRec fftrec)
{
    if (fftrec->plugin->instance == NULL) return SP_FALSE;

    if (SpFFTRecPluginRec(fftrec)->reset_fft_order == NULL) {
	spFreeFFT_Plugin(fftrec);
	return spInitFFT_Plugin(fftrec);
    }
    
    return SpFFTRecPluginRec(fftrec)->reset_fft_order(fftrec->plugin->instance, fftrec->plugin_fftrec,
						      fftrec->order);
}

spBool spExecFFTF_Plugin(spFFTRec fftrec, float *real, float *imag, int inv)
{
    if (fftrec->plugin->instance == NULL) return SP_FALSE;
    
    spDebug(80, "spExecFFTF_Plugin", "in\n");
    
    return SpFFTRecPluginRec(fftrec)->exec_fftf(fftrec->plugin->instance, fftrec->plugin_fftrec,
						real, imag, inv);
}

spBool spExecFFT_Plugin(spFFTRec fftrec, double *real, double *imag, int inv)
{
    if (fftrec->plugin->instance == NULL) return SP_FALSE;
    
    spDebug(80, "spExecFFT_Plugin", "in\n");
    
    return SpFFTRecPluginRec(fftrec)->exec_fft(fftrec->plugin->instance, fftrec->plugin_fftrec,
					       real, imag, inv);
}

spBool spExecRealFFTF_Plugin(spFFTRec fftrec, float *data, int inv)
{
    if (fftrec->plugin->instance == NULL) return SP_FALSE;
    
    spDebug(80, "spExecRealFFTF_Plugin", "in\n");
    
    return SpFFTRecPluginRec(fftrec)->exec_real_fftf(fftrec->plugin->instance, fftrec->plugin_fftrec,
						     data, inv);
}

spBool spExecRealFFT_Plugin(spFFTRec fftrec, double *data, int inv)
{
    if (fftrec->plugin->instance == NULL) return SP_FALSE;
    
    spDebug(80, "spExecRealFFT_Plugin", "in\n");
    
    return SpFFTRecPluginRec(fftrec)->exec_real_fft(fftrec->plugin->instance, fftrec->plugin_fftrec,
						    data, inv);
}

spBool spExecFFTPowerF_Plugin(spFFTRec fftrec, float *data, float exponent)
{
    if (fftrec->plugin->instance == NULL
	|| SpFFTRecPluginRec(fftrec)->exec_fft_powerf == NULL) return SP_FALSE;
    
    spDebug(80, "spExecFFTPowerF_Plugin", "in\n");
    
    return SpFFTRecPluginRec(fftrec)->exec_fft_powerf(fftrec->plugin->instance, fftrec->plugin_fftrec,
						      data, exponent);
}

spBool spExecFFTPower_Plugin(spFFTRec fftrec, double *data, double exponent)
{
    if (fftrec->plugin->instance == NULL
	|| SpFFTRecPluginRec(fftrec)->exec_fft_power == NULL) return SP_FALSE;
    
    spDebug(80, "spExecFFTPower_Plugin", "in\n");
    
    return SpFFTRecPluginRec(fftrec)->exec_fft_power(fftrec->plugin->instance, fftrec->plugin_fftrec,
						     data, exponent);
}
