/*
 *	fftplugin.h
 */

#ifndef SPLIB_FFTPLUGIN_H
#define SPLIB_FFTPLUGIN_H

#include <sp/spPluginP.h>
#include <sp/fft.h>

#ifdef __cplusplus
extern "C" {
#endif

/*#define SP_PLUGIN_FFT "FFT 1.2"*/
#define SP_PLUGIN_FFT "FFT 1.3"

#define SP_FFT_PLUGIN_CAPS_SUPPORT_BATCH (1<<(SP_PLUGIN_CAPS_USER_SHIFT))
#define SP_FFT_PLUGIN_CAPS_SUPPORT_ANY_LENGTH (2<<(SP_PLUGIN_CAPS_USER_SHIFT)) /* 1.3+ */
    
typedef struct _spFFTPluginRec spFFTPluginRec;
    
struct _spFFTPluginRec
{
    void *host_data;
    void *user_data;
    
    spPluginType type;
    char *plugin_id;
    long version_id;
    int priority;
    unsigned long caps;
    spBool (*init)(const char *lang);
    spBool (*free)(void);
    char *description;
    char *information;
    
    void *(*init_instance)(const char *lang);
    spBool (*free_instance)(void *instance);
    spOptions (*init_options)(void *instance, const char *lang);
    spBool (*free_options)(void *instance, spOptions options);

    spBool (*get_num_unit)(void *instance, int *num_unit);
    const char *(*get_unit_name)(void *instance, int index);
    spBool (*select_unit)(void *instance, int index);

    spBool (*is_precision_supported)(void *instance, spFFTPrecision precision, spFFTSpeed *speed);

    spBool (*set_other_info)(void *instance, const char *id, char *data);
    spBool (*get_other_info)(void *instance, const char *id, char *data);
    
    void *(*init_fft)(void *instance, long order, long batch, spFFTPrecision precision);    
    spBool (*free_fft)(void *instance, void *fftrec);
    spBool (*reset_fft_order)(void *instance, void *fftrec, long order);
    
    spBool (*exec_fftf)(void *instance, void *fftrec, float *real, float *imag, int inv);    
    spBool (*exec_fft)(void *instance, void *fftrec, double *real, double *imag, int inv);    

    spBool (*exec_real_fftf)(void *instance, void *fftrec, float *data, int inv);    
    spBool (*exec_real_fft)(void *instance, void *fftrec, double *data, int inv);    

    /* exec_fft_powerf and exec_fft_power can be NULL.
     * exponent=1.0:power spectrum, exponent=0.5:amplitude spectrum */
    spBool (*exec_fft_powerf)(void *instance, void *fftrec, float *data, float exponent);    
    spBool (*exec_fft_power)(void *instance, void *fftrec, double *data, double exponent);    
};

#define SpFFTRecPluginRec(fftrec) ((spFFTPluginRec *)fftrec->plugin->rec)

extern spBool spInitFFT_Plugin(spFFTRec fftrec);
extern spBool spFreeFFT_Plugin(spFFTRec fftrec);
extern spBool spResetFFTOrder_Plugin(spFFTRec fftrec);
extern spBool spExecFFTF_Plugin(spFFTRec fftrec, float *real, float *imag, int inv);
extern spBool spExecFFT_Plugin(spFFTRec fftrec, double *real, double *imag, int inv);
extern spBool spExecRealFFTF_Plugin(spFFTRec fftrec, float *data, int inv);
extern spBool spExecRealFFT_Plugin(spFFTRec fftrec, double *data, int inv);
extern spBool spExecFFTPowerF_Plugin(spFFTRec fftrec, float *data, float exponent);
extern spBool spExecFFTPower_Plugin(spFFTRec fftrec, double *data, double exponent);
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* SPLIB_FFTPLUGIN_H */
