#   File:       sp-cbn.make
#   Target:     sp-cbn
#   Created:    Monday, August 7, 2000 12:57:16 AM


MAKEFILE        = sp-cbn.make
# MondoBuild    = {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified
MondoBuild    =

SpBaseDir       = ::spBase:
SpLibDir  	= ::lib:
SpAudioDir      = ::spAudio:

ObjDir          = :
Includes        =  
				  -i :: 
				  -i {SpAudioDir} 
				  -i {SpBaseDir}

Sym-CBN         = -sym off

PPCCOptions     = {Includes} {Sym-CBN} -includes unix -enum int -d TARGET_API_MAC_CARBON=1 -w 35


### Source Files ###

SrcFiles        =  
				  base.c 
				  fft.c 
				  fftplugin.c 
				  fileio.c 
				  filter.c 
				  kaiser.c 
				  matrix.c 
				  sfconv.c 
				  vector.c 
				  voperate.c 
				  vmath.c 
				  window.c


### Object Files ###

ObjFiles-CBN    =  
				  "{ObjDir}base.c.y" 
				  "{ObjDir}fft.c.y" 
				  "{ObjDir}fftplugin.c.y" 
				  "{ObjDir}fileio.c.y" 
				  "{ObjDir}filter.c.y" 
				  "{ObjDir}kaiser.c.y" 
				  "{ObjDir}matrix.c.y" 
				  "{ObjDir}sfconv.c.y" 
				  "{ObjDir}vector.c.y" 
				  "{ObjDir}voperate.c.y" 
				  "{ObjDir}vmath.c.y" 
				  "{ObjDir}window.c.y"


### Libraries ###

LibFiles-CBN    = 


### Default Rules ###

.c.y    .c  {MondoBuild}
	{PPCC} {depDir}{default}.c -o {targDir}{default}.c.y {PPCCOptions}


### Build Rules ###

sp-cbn      sp-cbn.o

sp-cbn.o    {ObjFiles-CBN} {LibFiles-CBN} {MondoBuild}
	PPCLink 
		-o {Targ} 
		{ObjFiles-CBN} 
		{LibFiles-CBN} 
		{Sym-CBN} 
		-mf -d 
		-t 'XCOF' 
		-c 'MPS ' 
		-xm l; 
	Duplicate -y {Targ} {SpLibDir}



### Required Dependencies ###

"{ObjDir}base.c.y"    base.c
"{ObjDir}fft.c.y"    fft.c
"{ObjDir}fftplugin.c.y"    fftplugin.c
"{ObjDir}fileio.c.y"    fileio.c
"{ObjDir}filter.c.y"    filter.c
"{ObjDir}kaiser.c.y"    kaiser.c
"{ObjDir}matrix.c.y"    matrix.c
"{ObjDir}sfconv.c.y"    sfconv.c
"{ObjDir}vector.c.y"    vector.c
"{ObjDir}voperate.c.y"    voperate.c
"{ObjDir}vmath.c.y"    vmath.c
"{ObjDir}window.c.y"    window.c


### Optional Dependencies ###
### Build this target to generate "include file" dependencies. ###

Dependencies    $OutOfDate
	MakeDepend 
		-append {MAKEFILE} 
		-ignore "{CIncludes}" 
		-objdir "{ObjDir}" 
		-objext .y 
		{Includes} 
		{SrcFiles}


