#   File:       sp-ppc.make
#   Target:     sp-ppc
#   Created:    Monday, August 7, 2000 12:57:16 AM


MAKEFILE        = sp-ppc.make
# MondoBuild    = {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified
MondoBuild    =

SpBaseDir       = ::spBase:
SpLibDir  	= ::lib:
SpAudioDir      = ::spAudio:

ObjDir          = :
Includes        =  
				  -i :: 
				  -i {SpAudioDir} 
				  -i {SpBaseDir}

Sym-PPC         = -sym off

PPCCOptions     = {Includes} {Sym-PPC} -includes unix -enum int


### Source Files ###

SrcFiles        =  
				  base.c 
				  fft.c 
				  fftplugin.c 
				  fileio.c 
				  filter.c 
				  kaiser.c 
				  matrix.c 
				  sfconv.c 
				  vector.c 
				  voperate.c 
				  vmath.c 
				  window.c


### Object Files ###

ObjFiles-PPC    =  
				  "{ObjDir}base.c.x" 
				  "{ObjDir}fft.c.x" 
				  "{ObjDir}fftplugin.c.x" 
				  "{ObjDir}fileio.c.x" 
				  "{ObjDir}filter.c.x" 
				  "{ObjDir}kaiser.c.x" 
				  "{ObjDir}matrix.c.x" 
				  "{ObjDir}sfconv.c.x" 
				  "{ObjDir}vector.c.x" 
				  "{ObjDir}voperate.c.x" 
				  "{ObjDir}vmath.c.x" 
				  "{ObjDir}window.c.x"


### Libraries ###

LibFiles-PPC    = 


### Default Rules ###

.c.x    .c  {MondoBuild}
	{PPCC} {depDir}{default}.c -o {targDir}{default}.c.x {PPCCOptions}


### Build Rules ###

sp-ppc      sp-ppc.o

sp-ppc.o    {ObjFiles-PPC} {LibFiles-PPC} {MondoBuild}
	PPCLink 
		-o {Targ} 
		{ObjFiles-PPC} 
		{LibFiles-PPC} 
		{Sym-PPC} 
		-mf -d 
		-t 'XCOF' 
		-c 'MPS ' 
		-xm l; 
	Duplicate -y {Targ} {SpLibDir}



### Required Dependencies ###

"{ObjDir}base.c.x"    base.c
"{ObjDir}fft.c.x"    fft.c
"{ObjDir}fftplugin.c.x"    fftplugin.c
"{ObjDir}fileio.c.x"    fileio.c
"{ObjDir}filter.c.x"    filter.c
"{ObjDir}kaiser.c.x"    kaiser.c
"{ObjDir}matrix.c.x"    matrix.c
"{ObjDir}sfconv.c.x"    sfconv.c
"{ObjDir}vector.c.x"    vector.c
"{ObjDir}voperate.c.x"    voperate.c
"{ObjDir}vmath.c.x"    vmath.c
"{ObjDir}window.c.x"    window.c


### Optional Dependencies ###
### Build this target to generate "include file" dependencies. ###

Dependencies    $OutOfDate
	MakeDepend 
		-append {MAKEFILE} 
		-ignore "{CIncludes}" 
		-objdir "{ObjDir}" 
		-objext .x 
		{Includes} 
		{SrcFiles}


