/** @file sp/spLib.h
 */

#ifndef SPLIB_SPLIB_H
#define SPLIB_SPLIB_H

/**
@~english
@mainpage spLib - Library for Signal Processing
spLib is a library for speech signal processing. This library includes many
functions for signal processing.

@example fftvec.c @example filtertest.c @example interptest.c @example lpctest.c @example mattest.c
@example picolatest.c @example resampletest.c @example simple_fft.c @example simple_rfft.c @example vectest.c @example windowtest.c
 */

#include <sp/sp.h>
#include <sp/base.h>
#include <sp/memory.h>
#include <sp/fileio.h>
#include <sp/vector.h>
#include <sp/voperate.h>
#include <sp/matrix.h>
#include <sp/fft.h>
#include <sp/window.h>
#include <sp/kaiser.h>
#include <sp/filter.h>
#include <sp/sfconv.h>
#include <sp/cqt.h>

#endif /* SPLIB_SPLIB_H */
