#ifndef SPLIB_SPVECTORPLUGINP_H
#define SPLIB_SPVECTORPLUGINP_H

#include <sp/spPlugin.h>
#include <sp/vector.h>
#include <sp/fft.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_SVECTOR (1L<<0)
#define SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_LVECTOR (1L<<1)
#define SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_FVECTOR (1L<<2)
#define SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_DVECTOR (1L<<3)
#define SP_VECTOR_PLUGIN_FUNC_MASK_COMPLEX (1L<<8)

#define SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_ALL (SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_SVECTOR|SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_LVECTOR|SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_FVECTOR|SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_DVECTOR)
#define SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_SL (SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_SVECTOR|SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_LVECTOR)
#define SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_FD (SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_FVECTOR|SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_DVECTOR)
#define SP_VECTOR_PLUGIN_FUNC_MASK_ALL (SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_ALL|SP_VECTOR_PLUGIN_FUNC_MASK_COMPLEX)
#define SP_VECTOR_PLUGIN_FUNC_MASK_SL_COMPLEX (SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_SL|SP_VECTOR_PLUGIN_FUNC_MASK_COMPLEX)
#define SP_VECTOR_PLUGIN_FUNC_MASK_FD_COMPLEX (SP_VECTOR_PLUGIN_FUNC_MASK_TYPE_FD|SP_VECTOR_PLUGIN_FUNC_MASK_COMPLEX)

typedef struct _spVectorPluginFuncList spVectorPluginFuncList;
struct _spVectorPluginFuncList
{
    char *name;
    unsigned long mask;
    void *func;
};

/* internal use only */
typedef struct _spVectorPluginInternalFuncListOffsetTable spVectorPluginInternalFuncListOffsetTable;
struct _spVectorPluginInternalFuncListOffsetTable
{
    char *name;
    int offset;
};
    
/* internal use only (you can use these information to know function prototype) */
#define SP_VECTOR_PLUGIN_INTERNAL_FUNC_LIST_VERSION 0
#define SP_VECTOR_PLUGIN_INTERNAL_FUNC_LIST_REVISION 3
#define SP_VECTOR_PLUGIN_INTERNAL_FUNC_LIST_UPDATE_LEVEL 0
#define SP_VECTOR_PLUGIN_INTERNAL_FUNC_LIST_VERSION_ID	(SP_VECTOR_PLUGIN_INTERNAL_FUNC_LIST_VERSION * 1000 + SP_VECTOR_PLUGIN_INTERNAL_FUNC_LIST_REVISION)

typedef struct _spVectorPluginInternalFuncList spVectorPluginInternalFuncList;
struct _spVectorPluginInternalFuncList
{
    unsigned long version_id;
    
    spBool (*rset)(void *vinstance, long index, char *value);
    spBool (*rget)(void *vinstance, long index, char *value);
    spBool (*iset)(void *vinstance, long index, char *value);
    spBool (*iget)(void *vinstance, long index, char *value);
    
    spBool (*conj)(void *vinstance, long length);
    
    spBool (*rcopy)(void *y_vinstance, void *x_vinstance, long length);
    spBool (*icopy)(void *y_vinstance, void *x_vinstance, long length);
    spBool (*rcopyi)(void *y_vinstance, void *x_vinstance, long length);
    spBool (*icopyr)(void *y_vinstance, void *x_vinstance, long length);
    
    spBool (*radd)(void *y_vinstance, long y_offset, void *x_vinstance, long x_offset, long length, spBool overlap);
    spBool (*iadd)(void *y_vinstance, long y_offset, void *x_vinstance, long x_offset, long length, spBool overlap);

    spBool (*rerase)(void *vinstance, long length, long erase_offset, long erase_length, spBool inv);
    spBool (*ierase)(void *vinstance, long length, long erase_offset, long erase_length, spBool inv);
    
    spBool (*rinit)(void *vinstance, long length, double m, double incr, long num);
    spBool (*iinit)(void *vinstance, long length, double m, double incr, long num);

    /* ridxnums, iidxnums: 0.2.0+ */
    spBool (*ridxnums)(void *vinstance, long length, void *vidxinstance, long idx_length, double value);
    spBool (*iidxnums)(void *vinstance, long length, void *vidxinstance, long idx_length, double value);
    
    spBool (*rshift)(void *vinstance, long length, long shift, spBool circ_flag);
    spBool (*ishift)(void *vinstance, long length, long shift, spBool circ_flag);
    
    spBool (*plus)(void *x_vinstance, void *y_vinstance, long length);
    spBool (*minus)(void *x_vinstance, void *y_vinstance, long length, spBool rev);
    spBool (*times)(void *x_vinstance, void *y_vinstance, long length);
    spBool (*divide)(void *x_vinstance, void *y_vinstance, long length, spBool rev);
    spBool (*power)(void *x_vinstance, void *y_vinstance, long length, spBool rev);

    /* logiand, logior, logixor: 0.2.0+ */
    /* logical operation for real part only. nonzero value is converted to 1. */
    spBool (*logiand)(void *x_vinstance, void *y_vinstance, long length);
    spBool (*logior)(void *x_vinstance, void *y_vinstance, long length);
    spBool (*logixor)(void *x_vinstance, void *y_vinstance, long length);
    
    spBool (*scplus)(void *vinstance, long length, double t);
    spBool (*scminus)(void *vinstance, long length, double t, spBool rev);
    spBool (*sctimes)(void *vinstance, long length, double t);
    spBool (*scdivide)(void *vinstance, long length, double t, spBool rev);
    spBool (*scpower)(void *vinstance, long length, double t, spBool rev);

    spBool (*cplxplus)(void *vinstance, long length, double tr, double ti);
    spBool (*cplxminus)(void *vinstance, long length, double tr, double ti, spBool rev);
    spBool (*cplxtimes)(void *vinstance, long length, double tr, double ti);
    spBool (*cplxdivide)(void *vinstance, long length, double tr, double ti, spBool rev);
    spBool (*cplxpower)(void *vinstance, long length, double tr, double ti, spBool rev);

    spBool (*linplus)(void *vinstance, long length, double m, double incr);
    spBool (*linminus)(void *vinstance, long length, double m, double incr, spBool rev);
    spBool (*lintimes)(void *vinstance, long length, double m, double incr);
    spBool (*lindivide)(void *vinstance, long length, double m, double incr, spBool rev);
    spBool (*linpower)(void *vinstance, long length, double m, double incr, spBool rev);

    spBool (*morph)(void *x_vinstance, void *y_vinstance, long length, double x_rate, double y_rate);
    
    void *(*find)(void *vinstance, long length, long *nfound);
    spBool (*remap)(void *voinstance, void *vidxinstance, long length, void *viinstance, long ilength);
    
    spBool (*scevalle)(void *vinstance, long length, double t);
    spBool (*scevallt)(void *vinstance, long length, double t);
    spBool (*scevalge)(void *vinstance, long length, double t);
    spBool (*scevalgt)(void *vinstance, long length, double t);
    spBool (*scevaleq)(void *vinstance, long length, double t);
    spBool (*scevalne)(void *vinstance, long length, double t);
    
    double (*sum)(void *vinstance, long length);
    double (*isum)(void *vinstance, long length);
    double (*sqsum)(void *vinstance, long length);
    double (*abssum)(void *vinstance, long length);
    double (*norm)(void *vinstance, long length, long p);

    /* prod, riprod: 0.2.0+ */
    double (*prod)(void *vinstance, long length);
    double (*riprod)(void *vinstance, long length, double *o_iresult);
    
    double (*minfunc)(void *vinstance, long length, long *index);
    double (*maxfunc)(void *vinstance, long length, long *index);
    
    spBool (*scmin)(void *vinstance, long length, double value);
    spBool (*scmax)(void *vinstance, long length, double value);

    spBool (*elmin)(void *a_vinstance, void *b_vinstance, long length);
    spBool (*elmax)(void *a_vinstance, void *b_vinstance, long length);
    
    long (*nmin)(void *vinstance, long length, long n, long margin, unsigned long options, void *idxvinstance);
    long (*nmax)(void *vinstance, long length, long n, long margin, unsigned long options, void *idxvinstance);
    
    spBool (*abs)(void *vinstance, long length);
    spBool (*sqrt)(void *vinstance, long length);
    spBool (*square)(void *vinstance, long length);
    spBool (*sign)(void *vinstance, long length);
    
    spBool (*cumsum)(void *vinstance, long length);
    spBool (*cumprod)(void *vinstance, long length);
    spBool (*codiff)(void *vinstance, long length, double coef);
    
    spBool (*sort)(void *vinstance, long length);
    spBool (*sortidx)(void *vinstance, void *vidxinstance, long length);
    double (*median)(void *vinstance, long length); /* sort & median */
    
    long (*zerocross)(void *vinstance, long length, int slope_sign);
    
    /*-- the following is required for float and double only --*/
    spBool (*angle)(void *vinstance, long length);
    spBool (*unwrap)(void *vinstance, long length);

    /* n*: rms normalized window */
    spBool (*hamming)(void *vinstance, long length);
    spBool (*nhamming)(void *vinstance, long length);
    spBool (*hanning)(void *vinstance, long length);
    spBool (*nhanning)(void *vinstance, long length);
    spBool (*hann)(void *vinstance, long length);
    spBool (*nhann)(void *vinstance, long length);
    spBool (*blackman)(void *vinstance, long length);
    spBool (*nblackman)(void *vinstance, long length);
    spBool (*gausswin)(void *vinstance, long length, double alpha);
    spBool (*ngausswin)(void *vinstance, long length, double alpha);
    spBool (*kaiser)(void *vinstance, long length, double beta);
    spBool (*nkaiser)(void *vinstance, long length, double beta);
    spBool (*nboxcar)(void *vinstance, long length);
    
    spBool (*decibela)(void *vinstance, long length); /* for amplitude */
    spBool (*decibelp)(void *vinstance, long length); /* for power */
    spBool (*undecibela)(void *vinstance, long length); /* decibel to amplitude */
    spBool (*undecibelp)(void *vinstance, long length); /* decibel to power */

    void *(*initfft)(long order, long batch, spFFTPrecision precision);
    void *(*resetfft)(void *fftrec, long order);
    spBool (*freefft)(void *fftrec);
    
    spBool (*fft)(void *fftrec, void *vinstance, long length, int inv);
    
    spBool (*rfft)(void *fftrec, void *vinstance, long length, int inv);
    spBool (*rffttopower)(void *fftrec, void *vinstance, long length, double exponent);
    spBool (*rffttoreal)(void *fftrec, void *vinstance, long length);
    spBool (*rffttoimag)(void *fftrec, void *vinstance, long length);
    spBool (*rffttoangle)(void *fftrec, void *vinstance, long length);
    
    spBool (*fftturn)(void *fftrec, void *vinstance, long length);
    spBool (*fftshift)(void *fftrec, void *vinstance, long length);
    
    spBool (*fftgrpdly)(void *fftrec, void *vinstance, long length);
    spBool (*ceptompc)(void *fftrec, void *vinstance, long length);
    
    spBool (*srand)(unsigned int seed);
    spBool (*randun)(void *vinstance, long length);
    spBool (*gauss)(void *vinstance, long length, double mu, double sigma);
    
    double (*dot)(void *x_vinstance, void *y_vinstance, long length); /* real only */
    spBool (*cplxdot)(void *x_vinstance, void *y_vinstance, long length, double *re, double *im);
    
    spBool (*cos)(void *vinstance, long length);
    spBool (*sin)(void *vinstance, long length);
    spBool (*tan)(void *vinstance, long length);
    spBool (*cosh)(void *vinstance, long length);
    spBool (*sinh)(void *vinstance, long length);
    spBool (*tanh)(void *vinstance, long length);
    spBool (*acos)(void *vinstance, long length);
    spBool (*asin)(void *vinstance, long length);
    spBool (*atan)(void *vinstance, long length);
    
    spBool (*atan2)(void *y_vinstance, void *x_vinstance, long length, spBool rev);
    
    spBool (*exp)(void *vinstance, long length);
    spBool (*log)(void *vinstance, long length);
    spBool (*log10)(void *vinstance, long length);
};

struct _spVectorPluginRec
{
    void *host_data;
    void *user_data;
    
    spPluginType type;
    char *plugin_id;
    long version_id;
    int priority;
    unsigned long caps;
    spBool (*init)(const char *lang);
    spBool (*free)(void);
    char *description;
    char *information;
    
    /* required */
    void *(*init_instance)(const char *lang);
    spBool (*free_instance)(void *instance);

    /* optional */
    spOptions (*init_options)(void *instance, const char *lang);
    spBool (*free_options)(void *instance, spOptions options);

    /* optional */
    spBool (*get_num_unit)(void *instance, int *num_unit);
    const char *(*get_unit_name)(void *instance, int index);
    spBool (*select_unit)(void *instance, int index);
    
    /* optional */
    spBool (*is_precision_supported)(void *instance, spPrecision precision, spComputeSpeed *speed);
    spBool (*set_precision)(void *instance, spPrecision precision);
    spBool (*get_precision)(void *instance, spPrecision *precision);

    /* optional */
    spBool (*is_fast_mode_supported)(void *instance, spBool fast_flag);
    spBool (*set_fast_mode)(void *instance, spBool fast_flag); /* fast but low precision */
    spBool (*get_fast_mode)(void *instance, spBool *fast_flag);
    
    /* optional */
    spBool (*set_other_info)(void *instance, const char *id, char *data);
    spBool (*get_other_info)(void *instance, const char *id, char *data);
    
    /* optional */
    void *(*alloc_host)(void *instance, size_t size);
    spBool (*free_host)(void *instance, void *data);
    void *(*realloc_host)(void *instance, void *data, size_t size);

    /* required */
    void *(*get_func)(void *pinstance, char type, spBool cplx_flag, const char *func_name);
    
    /* required */
    void *(*get_vinstance)(void *pinstance, char type);
    spBool (*free_vinstance)(void *pinstance, void *vinstance);

    /* required */
    spBool (*ralloc)(void *vinstance, void *host_data, long length);
    spBool (*rfree)(void *vinstance);
    spBool (*ialloc)(void *vinstance, void *host_imag, long length);
    spBool (*ifree)(void *vinstance);
    spBool (*realloc)(void *vinstance, void *host_data, void *host_image, long old_length, long new_length);
    spBool (*imag)(void *vinstance, void *new_host_data, long length);
    spBool (*riswap)(void *vinstance, void *new_host_data, void *new_host_imag, long length);

    /* optional.  lock_switch: 0=normal, 1=transfer data only, 2=lock/unlock only (no transfer) */
    spBool (*rlock)(void *vinstance, void *data, long length, int lock_switch);
    spBool (*runlock)(void *vinstance, void *data, long length, int lock_switch);
    spBool (*ilock)(void *vinstance, void *imag, long length, int lock_switch);
    spBool (*iunlock)(void *vinstance, void *imag, long length, int lock_switch);

    /* required */
    void *(*getrptr)(void *vinstance);  /* The pointer associated with the real part. */
    void *(*getiptr)(void *vinstance);  /* The pointer associated with the imag part. */
};

#define SpVectorPluginRec(vec) ((spVectorPluginRec *)((vec)->plugin->rec))
#define SpMatrixPluginRec(mat) ((spVectorPluginRec *)((mat)->plugin->rec))

/* internal use only */    
#define SpGetVectorPluginInternalFuncList(vec, index) spGetVectorPluginInternalFuncList((vec)->plugin, index, (vec)->imag != NULL)
#define SpGetSVectorPluginInternalFuncList(vec) SpGetVectorPluginInternalFuncList(vec, 0)
#define SpGetLVectorPluginInternalFuncList(vec) SpGetVectorPluginInternalFuncList(vec, 1)
#define SpGetFVectorPluginInternalFuncList(vec) SpGetVectorPluginInternalFuncList(vec, 2)
#define SpGetDVectorPluginInternalFuncList(vec) SpGetVectorPluginInternalFuncList(vec, 3)

#define SpGetMatrixPluginInternalFuncList SpGetVectorPluginInternalFuncList
#define SpGetSMatrixPluginInternalFuncList SpGetSVectorPluginInternalFuncList
#define SpGetLMatrixPluginInternalFuncList SpGetLVectorPluginInternalFuncList
#define SpGetFMatrixPluginInternalFuncList SpGetFVectorPluginInternalFuncList
#define SpGetDMatrixPluginInternalFuncList SpGetDVectorPluginInternalFuncList

/* internal use only */    
extern spVectorPluginInternalFuncList *spGetVectorPluginInternalFuncList(spPlugin *plugin, int index, int cplx_flag);

extern int spGetVectorPluginFuncIndexFromList(spVectorPluginFuncList *list, const char *func_name);
extern spVectorPluginFuncList *spGetVectorPluginFuncFromList(spVectorPluginFuncList *list, const char *func_name);
extern void *spFindVectorPluginFuncFromList(spVectorPluginFuncList *list, char type, spBool cplx_flag, const char *func_name);

/* lockcore, unlockcore: internal use only */    
extern spBool svlockcore(spSVector x, int lock_switch);
extern spBool lvlockcore(spLVector x, int lock_switch);
extern spBool fvlockcore(spFVector x, int lock_switch);
extern spBool dvlockcore(spDVector x, int lock_switch);
extern spBool svunlockcore(spSVector x, int lock_switch);
extern spBool lvunlockcore(spLVector x, int lock_switch);
extern spBool fvunlockcore(spFVector x, int lock_switch);
extern spBool dvunlockcore(spDVector x, int lock_switch);

/* getrptr, getiptr: internal use only */    
extern void *svgetrptr(spSVector x);
extern void *lvgetrptr(spLVector x);
extern void *fvgetrptr(spFVector x);
extern void *dvgetrptr(spDVector x);
extern void *svgetiptr(spSVector x);
extern void *lvgetiptr(spLVector x);
extern void *fvgetiptr(spFVector x);
extern void *dvgetiptr(spDVector x);

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* SPLIB_SPVECTORPLUGINP_H */
