/*
 *	spButton.h
 */

#ifndef __SPBUTTON_H
#define __SPBUTTON_H

#include <sp/spLabel.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpButton "Button"
#define SpPushButton "PushButton"
#define SpToggleButton "ToggleButton"
#define SpCheckBox "CheckBox"
#define SpRadioButton "RadioButton"
    
#define SppSet "bSet"		/* CSG */
#define SppDefaultButton "bDefaultButton"	/* CG */
#define SppCancelButton "bCancelButton"		/* CG */
#define SppRadioEnd "bRadioEnd"	/* CG */

/* version 0.6.9+ */    
#define SppRadioGroupParent "PRadioGroupParent"	/* CG */

/* version 0.6.19+ */    
#define SppDestructiveButton "bDestructiveButton"	/* CG */

typedef struct _spButtonRec *spButton;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpButtonClass;

extern spBool spIsButton(spComponent component);
extern spBool spIsToggleButton(spComponent component);
extern spBool spIsRadioButton(spComponent component);
extern spComponent spCreatePushButton(spComponent parent, const char *name, ...);
extern spComponent spCreateCheckBox(spComponent parent, const char *name, ...);
extern spComponent spCreateRadioButton(spComponent parent, const char *name, ...);
extern spBool spSetToggleState(spComponent component, spBool set);
extern spBool spGetToggleState(spComponent component, spBool *set);
extern spBool spCheckRadioButton(spComponent component);
extern int spGetButtonDefaultHeight(spBool margin_flag);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPBUTTON_H */
