/*
 *	spCanvas.h
 */

#ifndef __SPCANVAS_H
#define __SPCANVAS_H

#include <sp/spPrimitive.h>
#include <sp/spGraphics.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpCanvas "Canvas"
    
/* for Cocoa and gtk3 */
#define SpPrintCanvas "PrintCanvas"
    
#define SppFocusable "bFocusable"	/* CG */
#define SppDrawBackground "bDrawBackground"	/* CG */
#define SppUseTabKey "bUseTabKey"	/* CG */
#define SppUseArrowKey "bUseArrowKey"	/* CG */

/* version 0.6.8+ */
#define SppDrawFunc "FDrawFunc" /* CSG */
#define SppDrawData "PDrawData" /* CSG */

/* version 0.6.13+ */
#define SppScrollHorizontal "bScrollHorizontal" /* CG */
#define SppHorizontalMinimum "iHorizontalMinimum"	/* CSG */
#define SppHorizontalMaximum "iHorizontalMaximum"	/* CSG */
#define SppHorizontalValue "iHorizontalValue"	/* CSG */
#define SppHorizontalIncrement "iHorizontalIncrement" /* CSG */
#define SppHorizontalPageIncrement "iHorizontalPageIncrement" /* CSG */
#define SppHorizontalPageSize "iHorizontalPageSize"	/* CSG */
#define SppHorizontalContentFactor "dHorizontalContentFactor"	/* CSG */
#define SppScrollVertical "bScrollVertical" /* CG */
#define SppVerticalMinimum "iVerticalMinimum"	/* CSG */
#define SppVerticalMaximum "iVerticalMaximum"	/* CSG */
#define SppVerticalValue "iVerticalValue"	/* CSG */
#define SppVerticalIncrement "iVerticalIncrement" /* CSG */
#define SppVerticalPageIncrement "iVerticalPageIncrement" /* CSG */
#define SppVerticalPageSize "iVerticalPageSize"	/* CSG */
#define SppVerticalContentFactor "dVerticalContentFactor"	/* CSG */

/* version 0.6.14+ */
#define SppAcceptWheelEvent "bAcceptWheelEvent" /* CG */
#define SppHorizontalWheelIncrement "iHorizontalWheelIncrement" /* CSG */
#define SppVerticalWheelIncrement "iVerticalWheelIncrement" /* CSG */

#define SppWheelTargetHorizontal "bWheelTargetHorizontal" /* CSG */
#define SppScrollLeftByWheelDown "bScrollLeftByWheelDown" /* CSG */

/* version 0.6.19+ */
/* button motion will act as wheel motion on environment that a wheel doesn't exist */
#define SppWheelSubstitutiveButton "eWheelSubstitutiveButton" /* CG */

typedef struct _spCanvasRec *spCanvas;
typedef struct _spCanvasClassRec *spCanvasClass;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpCanvasClass;
    
extern spBool spIsCanvas(spComponent component);
extern spBool spIsScrollCanvas(spComponent component);
extern spComponent spCreateCanvas(spComponent parent, const char *name,
				  int canvas_width, int canvas_height, ...);
extern spBool spRefreshCanvas(spComponent component);
extern spBool spRedrawCanvas(spComponent component);
extern spBool spSetCanvasCapture(spComponent component, spBool flag);
extern spBool spSetCanvasCursor(spComponent component, spCursor cursor);
extern spBool spUnsetCanvasCursor(spComponent component);
extern spBool spIsCanvasFocused(spComponent component);
extern spBool spZoomScrollCanvas(spComponent component, double relative_factor);
extern void spZoomInScrollCanvasCB(spComponent component, spComponent canvas);
extern void spZoomOutScrollCanvasCB(spComponent component, spComponent canvas);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPCANVAS_H */
