/*
 *	spComponent.h
 */

#ifndef __SPCOMPONENT_H
#define __SPCOMPONENT_H

#include <sp/spObject.h>
#include <sp/spTopLevel.h>
    
#ifdef __cplusplus
extern "C" {
#endif

#define SpComponent "Component"
    
#define SppTitle "STitle"	/* CSG */
#define SppDescription "SDescription" /* CSG */
#define SppUserData "PUserData" 	/* CSG */
#define SppGroupId "lGroupId"	/* CSG */
#define SppSenseLevel "lSenseLevel" /* CSG */
#define SppOrientation "eOrientation" /* CG */
#define SppSpacingOn "bSpacingOn" /* CG */
#define SppVisible "bVisible"	/* CG */
#define SppSize "iSize"	/* CG */
#define SppWidth "iWidth"	/* CSG */
#define SppHeight "iHeight"	/* CSG */
#define SppInitialWidth "iInitialWidth" /* CS */
#define SppInitialHeight "iInitialHeight" /* CS */
#define SppMarginWidth "iMarginWidth" /* CG   margin width for children */
#define SppMarginHeight "iMarginHeight" /* CG   margin height for children */
#define SppSpacing "iSpacing"	/* CG  spacing for children */
/*#define SppOffset "iOffset"*/	/* CG */
/*#define SppTabStop "bTabStop"*/	/* CG */
#define SppCallbackFunc "FCallbackFunc" /* C */
#define SppCallbackData "PCallbackData" /* C */

/* 0.6.6+ */
#define SppHelpPath "SHelpPath"	/* CSG */

/* 0.6.8+ */
#define SppPercentageWidth "iPercentageWidth" /* CSG  must be used with SppInitialWidth */
#define SppPercentageHeight "iPercentageHeight" /* CSG   must be used with SppInitialHeight */
  
/* 0.6.18+ */
#define SppDisableInitialScaling "bDisableInitialScaling" /* CG */
#define SppParentComponent "PParentComponent" /* CG */
    
#define SP_INIT_GROUP_ID (0)
#define SP_INIT_GROUP_ID_STRING "0"
#define SP_ALL_GROUP_ID (-1)
#define SP_ALL_GROUP_ID_STRING "-1"
#define SP_EXCLUSIVE_GROUP_ID (-2) /* sensitive level is set only if group IDs are same */
#define SP_EXCLUSIVE_GROUP_ID_STRING "-2"
#define SP_DEFAULT_GROUP_ID SP_INIT_GROUP_ID
    
typedef struct _spComponentRec *spComponent;
typedef struct _spComponentClassRec *spComponentClass;

typedef void *spCallbackData;
typedef void (*spCallbackFunc)(spComponent component, void *call_data);
typedef void (*spDropCallbackFunc)(spComponent component, void *call_data, int argc, char **argv);

typedef spBool (*spTimerCallbackFunc)(spComponent frame, void *call_data);
typedef spBool (*spEventCallbackFunc)(spComponent component, spEventType event_type, void *call_data);
    
#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpComponentClass;

extern spBool spSetParamsArg(spComponent component, spArg *args, int num_arg);
extern spBool spSetParams(spComponent component, ...);
extern spBool spGetParamsArg(spComponent component, spArg *args, int num_arg);
extern spBool spGetParams(spComponent component, ...);
extern void spDestroyComponent(spComponent component);
extern void spMapComponent(spComponent component);
extern void spUnmapComponent(spComponent component);
extern spBool spAddCallback(spComponent component, spCallbackType call_type,
			    spCallbackFunc call_func, void *call_data);
extern spBool spAddPropagateCallback(spComponent component, spCallbackType call_type,
				     spCallbackFunc call_func, void *call_data);
extern spBool spRemoveCallback(spComponent component, spCallbackType call_type,
			       spCallbackFunc call_func, void *call_data);
extern spCallbackReason spGetCallbackReason(spComponent component);
extern spBool spGetCallbackMousePosition(spComponent component, int *x, int *y);
extern spBool spGetCallbackWheelValue(spComponent component, double *delta_x, double *delta_y); /* canvas only */
extern spBool spGetCallbackKeySym(spComponent component, spKeySym *key_sym);
extern int spGetCallbackKeyString(spComponent component,
				  char *buf, int buf_size, spBool *overflow);
extern spBool spGetModifierKeyMask(spComponent component, spModifierMask *mask);
extern spBool spOverwritePrompt(spComponent component, const char *filename);
extern spBool spSaveChangesPrompt(spComponent component, const char *filename);
extern spBool spQuitPrompt(spComponent component);
extern void spQuitCB(spComponent component, spBool no_prompt);
extern spBool spSetComponentSize(spComponent component, int width, int height);
extern spBool spSetSize(spComponent component, int width, int height);
extern spBool spSetRequireSize(spComponent component, int width, int height);
extern spBool spGetComponentSize(spComponent component, int *width, int *height);
extern spBool spGetClientSize(spComponent component, int *width, int *height);
extern spBool spGetSize(spComponent component, int *width, int *height);
extern spBool spSetSensitive(spComponent component, spBool flag);
extern spBool spSetUserData(spComponent component, void *data);
extern void *spGetUserData(spComponent component);
extern const char *spGetName(spComponent component);
extern const char *spGetTitle(spComponent component);
extern long spGetComponentId(spComponent component);
extern spComponent spGetComponent(spComponent component);
extern spComponent spGetParent(spComponent component);
extern spComponent spGetChild(spComponent component);
extern spComponent spGetLastChild(spComponent component);
extern spComponent spGetNextComponent(spComponent component);
extern spComponent spGetPrevComponent(spComponent component);
extern spComponent spGetWindow(spComponent component);
extern void *spGetArchWindow(spComponent component);
extern spBool spSetCurrentSenseLevel(long group_id, long level);
extern spBool spSetWindowSenseLevel(spComponent component, long group_id, long level);
extern spBool spGetWindowSenseLevel(spComponent component, long group_id, long *level);
extern spBool spSetSenseLevel(spComponent component, long level);
extern spBool spGetSenseLevel(spComponent component, long *level);
extern spBool spIsCreated(spComponent component);
extern spBool spIsVisible(spComponent component);
extern spBool spIsSensitive(spComponent component);
extern spBool spIsResizable(spComponent component);
extern spBool spIsSpacingOn(spComponent component);
extern spBool spEqClass(spComponent component, const char *class_name);
extern spBool spIsSubClass(spComponent component, const char *class_name);
extern spBool spIsComponentType(spComponent component, const char *class_name);

extern spBool spIsWindow(spComponent component);
extern void spDestroyWindow(spComponent component);
extern void spDestroyAllWindow(void);
extern void spCloseWindowPrompt(spComponent component, spBool prompt);
extern void spCloseWindow(spComponent component);
extern void spPopupWindow(spComponent component);
extern void spPopdownWindow(spComponent component);
extern void spMapWindow(spComponent component);
extern void spUnmapWindow(spComponent component);
extern void spRaiseWindow(spComponent component);
extern void spLowerWindow(spComponent component);
extern spBool spIsTaskTrayVisible(spComponent component);
extern spBool spShowTaskTray(spComponent component, spBool flag);
extern void spAdjustWindowSize(spComponent component, spBool reset);
extern spBool spAllocateSize(spComponent component, int width, int height);
extern spBool spSetWindowPosition(spComponent component, int x, int y);
extern spBool spGetWindowPosition(spComponent component, int *x, int *y);
extern void spDestroyWindowCB(spComponent component, void *data);
extern void spCloseWindowCB(spComponent component, void *data);
extern void spPopupWindowCB(spComponent component, void *data);
extern void spPopdownWindowCB(spComponent component, void *data);
extern spComponent spGetNextWindow(spComponent component, spBool dialog_flag);
extern spComponent spGetPrevWindow(spComponent component, spBool dialog_flag);
extern void spPopupNextWindow(spComponent component, spBool dialog_flag);
extern void spPopupPrevWindow(spComponent component, spBool dialog_flag);
extern spBool spIsLastWindow(spComponent component);

/* 0.6.13+ */
extern spBool spIsAncestor(spComponent component, spComponent target);
extern spBool spIsDescendant(spComponent component, spComponent target);

/* 0.6.17+ */
extern int spCountChildren(spComponent component);

/* internal use only */
extern spComponent spCreateComponentArg(spComponentClass component_class, const char *class_name,
					const char *name, spComponent parent, 
					spArg *args, int num_arg);
extern void spFreeComponent(spComponent component);
/* 0.6.21+, internal use only */
extern void *spGetInternalCallbackData(spComponent component);

/* 0.6.23+ */
extern int spScaleComponentX(spComponent component, int x);
extern int spScaleComponentY(spComponent component, int y);
extern int spUnscaleComponentX(spComponent component, int x);
extern int spUnscaleComponentY(spComponent component, int y);

#if defined(MACOS)
#pragma import off
#endif

#define spSetParam spSetParams
#define spGetParam spGetParams

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPCOMPONENT_H */
