/*
 *	spContainer.h
 */

#ifndef __SPCONTAINER_H
#define __SPCONTAINER_H

#include <sp/spPrimitive.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpContainer "Container"
#define SpBox "Box"
    
#define SppBorderOn "bBorderOn"	/* CG */
#define SppTitleOn "bTitleOn"	/* CG */
#define SppUseTextHeight "bUseTextHeight"	/* C */

typedef struct _spContainerRec *spContainer;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpContainerClass;
    
extern spBool spIsContainer(spComponent component);
extern spComponent spCreateBox(spComponent parent, const char *name, int size, ...);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPCONTAINER_H */
