/*
 *	spDIBitmap.h
 */

#ifndef __SPDIBITMAP_H
#define __SPDIBITMAP_H

#include <sp/spDefs.h>
#include <sp/spPlugin.h>
#include <sp/spComponent.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SP_PLUGIN_DIBITMAP "dibitmap 0.1"

#define SP_PLUGIN_INFO_DIBITMAP_GAMMA "dibitmap_gamma" /* (double *) */
#define SP_PLUGIN_INFO_DIBITMAP_COMPRESSION_QUALITY "dibitmap_compression_quality" /* (short *), the value ranges from 0 to 100 */
    
#define SP_DI_BITMAP_CAPS_DIRECT_ACCESS (1L)
#define SP_DI_BITMAP_CAPS_COPY_IMAGE (1L<<1)
#define SP_DI_BITMAP_CAPS_COPY_IMAGE_STRETCHABLE (1L<<2)
#define SP_DI_BITMAP_CAPS_COPY_ALPHA (1L<<3)
#define SP_DI_BITMAP_CAPS_READ (1L<<4)
#define SP_DI_BITMAP_CAPS_WRITE (1L<<5)
#define SP_DI_BITMAP_CAPS_READ_REPLACE_BITMAP (1L<<6)
#define SP_DI_BITMAP_CAPS_READ_USE_BITMAP_ARGUMENT (1L<<7)
#define SP_DI_BITMAP_CAPS_WRITE_USE_BITMAP_ARGUMENT (1L<<8)
#define SP_DI_BITMAP_CAPS_UPSIDE_UP (1L<<9)
#define SP_DI_BITMAP_CAPS_UPSIDE_DOWN (1L<<10)
#define SP_DI_BITMAP_CAPS_PIXEL_STRIDE_3 (1L<<11)
#define SP_DI_BITMAP_CAPS_PIXEL_STRIDE_4 (1L<<12)
#define SP_DI_BITMAP_CAPS_FLOAT (1L<<13)
#define SP_DI_BITMAP_CAPS_BIT_SIZE_16 (1L<<14)
#define SP_DI_BITMAP_CAPS_BIT_SIZE_32 (1L<<15)
#define SP_DI_BITMAP_CAPS_RGB_UNSUPPORTED (1L<<16)
#define SP_DI_BITMAP_CAPS_NONINVERSE_FORMAT (1L<<17)
#define SP_DI_BITMAP_CAPS_INVERSE_FORMAT (1L<<18)
#define SP_DI_BITMAP_CAPS_ALPHA (1L<<19) /* non-premultiplied alpha */
#define SP_DI_BITMAP_CAPS_ALPHA_PREMULTIPLIED (1L<<20)
#define SP_DI_BITMAP_CAPS_FIRST_ALPHA (1L<<21)
#define SP_DI_BITMAP_CAPS_FIRST_NULL SP_DI_BITMAP_CAPS_FIRST_ALPHA
#define SP_DI_BITMAP_CAPS_LAST_ALPHA (1L<<22)
#define SP_DI_BITMAP_CAPS_LAST_NULL SP_DI_BITMAP_CAPS_LAST_ALPHA
#define SP_DI_BITMAP_CAPS_ALPHA_ONLY (1L<<23)
#define SP_DI_BITMAP_CAPS_GRAYSCALE (1L<<24)
#define SP_DI_BITMAP_CAPS_YUV (1L<<25)
#define SP_DI_BITMAP_CAPS_SINGLE_RGB (1L<<26)
#define SP_DI_BITMAP_CAPS_GAMMA (1L<<30)
#define SP_DI_BITMAP_CAPS_COMPRESSION_QUALITY (1L<<31)
    
#define SP_DI_BITMAP_OPTION_ACCEPT_NONNATIVE (1L)
#define SP_DI_BITMAP_OPTION_FORCE_NONNATIVE (1L<<1)
#define SP_DI_BITMAP_OPTION_AVOID_NATIVE_BASED_IO (1L<<2)
#define SP_DI_BITMAP_STRICT_NONNATIVE (1L<<15)
#define SP_DI_BITMAP_STRICT_ENDIAN (1L<<16)
#define SP_DI_BITMAP_STRICT_FLOAT_STATE (1L<<17)
#define SP_DI_BITMAP_STRICT_SINGLE_RGB_STATE (1L<<18)
#define SP_DI_BITMAP_STRICT_GRAYSCALE_STATE (1L<<19)
#define SP_DI_BITMAP_STRICT_YUV_STATE (1L<<20)
#define SP_DI_BITMAP_STRICT_YUV_RATIO (1L<<21)
#define SP_DI_BITMAP_STRICT_YUV_BIT (1L<<22)
#define SP_DI_BITMAP_STRICT_YUV_ORDER (1L<<23)
#define SP_DI_BITMAP_STRICT_ALPHA_STATE (1L<<24)
#define SP_DI_BITMAP_STRICT_ALPHA_ORDER (1L<<25)
#define SP_DI_BITMAP_STRICT_ALPHA_PREMULTIPLIED_STATE (1L<<26)
#define SP_DI_BITMAP_STRICT_PIXEL_ORDER (1L<<27)
#define SP_DI_BITMAP_STRICT_PIXEL_STRIDE (1L<<28)
#define SP_DI_BITMAP_STRICT_LINE_STRIDE (1L<<29)
#define SP_DI_BITMAP_STRICT_BIT_SIZE (1L<<30)
#define SP_DI_BITMAP_STRICT_UPSIDE_DOWN_STATE (1L<<31)
#define SP_DI_BITMAP_STRICT_ALL 0xffff0000
#define SP_DI_BITMAP_STRICT_MASK 0xfffff000
    
typedef unsigned long spDIPixelFormat;
#define SP_DI_PIXEL_FORMAT_RGB_MASK (1L)
#define SP_DI_PIXEL_FORMAT_INVERSE_MASK (1L<<1)
#define SP_DI_PIXEL_FORMAT_FIRST_ALPHA_MASK (1L<<2)
#define SP_DI_PIXEL_FORMAT_FIRST_NULL_MASK SP_DI_PIXEL_FORMAT_FIRST_ALPHA_MASK
#define SP_DI_PIXEL_FORMAT_LAST_ALPHA_MASK (1L<<3)
#define SP_DI_PIXEL_FORMAT_LAST_NULL_MASK SP_DI_PIXEL_FORMAT_LAST_ALPHA_MASK
#define SP_DI_PIXEL_FORMAT_ALPHA_MASK (1L<<4)
#define SP_DI_PIXEL_FORMAT_ALPHA_PREMULTIPLIED_MASK (1L<<5)
#define SP_DI_PIXEL_FORMAT_SWAP_ENDIAN_PIXEL_MASK (1L<<6) /* for pixel > 8 bit */
#define SP_DI_PIXEL_FORMAT_FLOAT_MASK (1L<<7)
#define SP_DI_PIXEL_FORMAT_YUV_MASK (1L<<8)
#define SP_DI_PIXEL_FORMAT_GRAYSCALE_MASK (1L<<9)
#define SP_DI_PIXEL_FORMAT_SINGLE_RGB_MASK (1L<<10)
    
#define SP_DI_PIXEL_FORMAT_YUV_RATIO444_MASK (1L<<15)
#define SP_DI_PIXEL_FORMAT_YUV_RATIO422_MASK (1L<<16)
#define SP_DI_PIXEL_FORMAT_YUV_RATIO411_MASK (1L<<17)
#define SP_DI_PIXEL_FORMAT_YUV_RATIO420_MASK (1L<<18)
#define SP_DI_PIXEL_FORMAT_YUV_RATIO410_MASK (1L<<19)
#define SP_DI_PIXEL_FORMAT_YUV_BIT24_MASK (1L<<20)
#define SP_DI_PIXEL_FORMAT_YUV_BIT16_MASK (1L<<21)
#define SP_DI_PIXEL_FORMAT_YUV_BIT12_MASK (1L<<22)
#define SP_DI_PIXEL_FORMAT_YUV_BIT9_MASK (1L<<23)
#define SP_DI_PIXEL_FORMAT_YUV_ORDER_YUV_MASK (1L<<24)
#define SP_DI_PIXEL_FORMAT_YUV_ORDER_YVU_MASK (1L<<25)
#define SP_DI_PIXEL_FORMAT_YUV_ORDER_UYVY_MASK (1L<<26)
#define SP_DI_PIXEL_FORMAT_YUV_ORDER_YUYV_MASK (1L<<27)
#define SP_DI_PIXEL_FORMAT_YUV_ORDER_YVYU_MASK (1L<<28)
#define SP_DI_PIXEL_FORMAT_YUV_ORDER_UYV_MASK (1L<<29)
    
#define SP_DI_PIXEL_FORMAT_SINGLE_RGB_ALPHA_RATIO21 (1L<<22)
#define SP_DI_PIXEL_FORMAT_SINGLE_RGB_ALPHA_RATIO31 (1L<<23)
#define SP_DI_PIXEL_FORMAT_SINGLE_RGB_ALPHA_RATIO41 (1L<<24)
#define SP_DI_PIXEL_FORMAT_SINGLE_RGB_RATIO443_MASK (1L<<25)
#define SP_DI_PIXEL_FORMAT_SINGLE_RGB_RATIO554_MASK (1L<<26)
#define SP_DI_PIXEL_FORMAT_SINGLE_RGB_RATIO565_MASK (1L<<27)
#define SP_DI_PIXEL_FORMAT_SINGLE_RGB_RATIO332_MASK (1L<<28)
#define SP_DI_PIXEL_FORMAT_SINGLE_RGB_ALPHA_RATIO51 (1L<<29)

#define SP_DI_PIXEL_FORMAT_MASK (0x3fffffff)
#define SP_DI_PIXEL_FORMAT_OPTIONAL_PARAMETERS_MASK (0x3ffff000)
#define SP_DI_BITMAP_TYPE_MASK (0xc0000000)
#define SP_DI_BITMAP_TYPE_PLUGIN_MASK (1L<<31)
#define SP_DI_BITMAP_TYPE_NONNATIVE_MASK (1L<<30) /* cannot draw but can copy and modify */
    
#define SP_DI_PIXEL_FORMAT_GRAY SP_DI_PIXEL_FORMAT_GRAYSCALE_MASK
#define SP_DI_PIXEL_FORMAT_GRAY_ALPHA (SP_DI_PIXEL_FORMAT_GRAYSCALE_MASK|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_LAST_ALPHA_MASK)
#define SP_DI_PIXEL_FORMAT_ALPHA_GRAY (SP_DI_PIXEL_FORMAT_GRAYSCALE_MASK|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_FIRST_ALPHA_MASK)
#define SP_DI_PIXEL_FORMAT_ALPHA_ONLY SP_DI_PIXEL_FORMAT_ALPHA_MASK
#define SP_DI_PIXEL_FORMAT_RGB SP_DI_PIXEL_FORMAT_RGB_MASK
#define SP_DI_PIXEL_FORMAT_BGR (SP_DI_PIXEL_FORMAT_RGB_MASK|SP_DI_PIXEL_FORMAT_INVERSE_MASK)
#define SP_DI_PIXEL_FORMAT_RGBA (SP_DI_PIXEL_FORMAT_RGB|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_LAST_ALPHA_MASK)
#define SP_DI_PIXEL_FORMAT_BGRA (SP_DI_PIXEL_FORMAT_BGR|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_LAST_ALPHA_MASK)
#define SP_DI_PIXEL_FORMAT_RGBP (SP_DI_PIXEL_FORMAT_RGB|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_LAST_ALPHA_MASK|SP_DI_PIXEL_FORMAT_ALPHA_PREMULTIPLIED_MASK)
#define SP_DI_PIXEL_FORMAT_BGRP (SP_DI_PIXEL_FORMAT_BGR|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_LAST_ALPHA_MASK|SP_DI_PIXEL_FORMAT_ALPHA_PREMULTIPLIED_MASK)
#define SP_DI_PIXEL_FORMAT_RGBN (SP_DI_PIXEL_FORMAT_RGB|SP_DI_PIXEL_FORMAT_LAST_NULL_MASK)
#define SP_DI_PIXEL_FORMAT_BGRN (SP_DI_PIXEL_FORMAT_BGR|SP_DI_PIXEL_FORMAT_LAST_NULL_MASK)
#define SP_DI_PIXEL_FORMAT_ARGB (SP_DI_PIXEL_FORMAT_RGB_MASK|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_FIRST_ALPHA_MASK)
#define SP_DI_PIXEL_FORMAT_ABGR (SP_DI_PIXEL_FORMAT_RGB_MASK|SP_DI_PIXEL_FORMAT_INVERSE_MASK|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_FIRST_ALPHA_MASK)
#define SP_DI_PIXEL_FORMAT_PRGB (SP_DI_PIXEL_FORMAT_RGB_MASK|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_FIRST_ALPHA_MASK|SP_DI_PIXEL_FORMAT_ALPHA_PREMULTIPLIED_MASK)
#define SP_DI_PIXEL_FORMAT_PBGR (SP_DI_PIXEL_FORMAT_RGB_MASK|SP_DI_PIXEL_FORMAT_INVERSE_MASK|SP_DI_PIXEL_FORMAT_ALPHA_MASK|SP_DI_PIXEL_FORMAT_FIRST_ALPHA_MASK|SP_DI_PIXEL_FORMAT_ALPHA_PREMULTIPLIED_MASK)
#define SP_DI_PIXEL_FORMAT_NRGB (SP_DI_PIXEL_FORMAT_RGB_MASK|SP_DI_PIXEL_FORMAT_FIRST_NULL_MASK)
#define SP_DI_PIXEL_FORMAT_NBGR (SP_DI_PIXEL_FORMAT_RGB_MASK|SP_DI_PIXEL_FORMAT_INVERSE_MASK|SP_DI_PIXEL_FORMAT_FIRST_NULL_MASK)
#define SP_DI_PIXEL_FORMAT_YUY2 (SP_DI_PIXEL_FORMAT_YUV_MASK|SP_DI_PIXEL_FORMAT_YUV_RATIO422_MASK|SP_DI_PIXEL_FORMAT_YUV_BIT16_MASK|SP_DI_PIXEL_FORMAT_YUV_ORDER_YUYV_MASK)
#define SP_DI_PIXEL_FORMAT_UYVY (SP_DI_PIXEL_FORMAT_YUV_MASK|SP_DI_PIXEL_FORMAT_YUV_RATIO422_MASK|SP_DI_PIXEL_FORMAT_YUV_BIT16_MASK|SP_DI_PIXEL_FORMAT_YUV_ORDER_UYVY_MASK)
#define SP_DI_PIXEL_FORMAT_YVYU (SP_DI_PIXEL_FORMAT_YUV_MASK|SP_DI_PIXEL_FORMAT_YUV_RATIO422_MASK|SP_DI_PIXEL_FORMAT_YUV_BIT16_MASK|SP_DI_PIXEL_FORMAT_YUV_ORDER_YVYU_MASK)
#define SP_DI_PIXEL_FORMAT_IYU1 (SP_DI_PIXEL_FORMAT_YUV_MASK|SP_DI_PIXEL_FORMAT_YUV_RATIO422_MASK|SP_DI_PIXEL_FORMAT_YUV_BIT12_MASK|SP_DI_PIXEL_FORMAT_YUV_ORDER_UYVY_MASK)
#define SP_DI_PIXEL_FORMAT_IYU2 (SP_DI_PIXEL_FORMAT_YUV_MASK|SP_DI_PIXEL_FORMAT_YUV_RATIO422_MASK|SP_DI_PIXEL_FORMAT_YUV_BIT24_MASK|SP_DI_PIXEL_FORMAT_YUV_ORDER_UYV_MASK)
#define SP_DI_PIXEL_FORMAT_YV12 (SP_DI_PIXEL_FORMAT_YUV_MASK|SP_DI_PIXEL_FORMAT_YUV_RATIO420_MASK|SP_DI_PIXEL_FORMAT_YUV_BIT12_MASK|SP_DI_PIXEL_FORMAT_YUV_ORDER_YVU_MASK)
#define SP_DI_PIXEL_FORMAT_IYUV (SP_DI_PIXEL_FORMAT_YUV_MASK|SP_DI_PIXEL_FORMAT_YUV_RATIO420_MASK|SP_DI_PIXEL_FORMAT_YUV_BIT12_MASK|SP_DI_PIXEL_FORMAT_YUV_ORDER_YUV_MASK)
#define SP_DI_PIXEL_FORMAT_YVU9 (SP_DI_PIXEL_FORMAT_YUV_MASK|SP_DI_PIXEL_FORMAT_YUV_RATIO410_MASK|SP_DI_PIXEL_FORMAT_YUV_BIT9_MASK|SP_DI_PIXEL_FORMAT_YUV_ORDER_YVU_MASK)

#if defined(_WIN32) && !defined(USE_MOTIF)
#define SP_DI_PIXEL_FORMAT_DEFAULT SP_DI_PIXEL_FORMAT_BGR
#elif defined(ANDROID)
#define SP_DI_PIXEL_FORMAT_DEFAULT SP_DI_PIXEL_FORMAT_RGBA
#elif defined(COCOA) && defined(IPHONE)
#define SP_DI_PIXEL_FORMAT_DEFAULT SP_DI_PIXEL_FORMAT_RGBP
#elif defined(COCOA)
#define SP_DI_PIXEL_FORMAT_DEFAULT SP_DI_PIXEL_FORMAT_RGBA
#elif defined(MACOS)
#define SP_DI_PIXEL_FORMAT_DEFAULT SP_DI_PIXEL_FORMAT_ARGB
#else
#define SP_DI_PIXEL_FORMAT_DEFAULT SP_DI_PIXEL_FORMAT_RGB
#endif
    
#if BYTE_ORDER == BIG_ENDIAN
#define SP_BMP_NEED_SWAP 1
#else
#define SP_BMP_NEED_SWAP 0
#endif

typedef struct _spDIBitmap *spDIBitmap;
typedef struct _spDIBitmapInfo spDIBitmapInfo;
typedef struct _spDIBitmapInfoInternal spDIBitmapInfoInternal;
typedef struct _spDIBitmapFuncList spDIBitmapFuncList;
typedef struct _spDIBitmapHandler *spDIBitmapHandler;
    
typedef struct _spDIBitmapPluginRec spDIBitmapPluginRec;

struct _spDIBitmapInfo {
    spDIPixelFormat pixel_format;

    long width, height;
    spBool upside_down;
    long bit_size;		/* basically, 8 bit */
};

struct _spDIBitmapInfoInternal {
    spDIPixelFormat pixel_format;

    long width, height;
    spBool upside_down;
    long bit_size;		/* basically, 8 bit */
    long pixel_stride;		/* 3 (24 bit) or 4 (32 bit) is typical */
    long line_stride;		/* size of each line; this value can be changed after spLockDIBitmap (on Mac) */
    spBool locked;
    unsigned char *data;
};

struct _spDIBitmap {
    spDIBitmapInfoInternal info;
    void *dibitmap;

    spDIBitmapHandler handler;
};

#define SP_META_INFO_SIZE 128
    
#define SP_META_NO_INFO 0
#define SP_META_NUMBER_MASK (1L<<0)
#define SP_META_TITLE_MASK (1L<<1)
#define SP_META_AUTHOR_MASK (1L<<2)
#define SP_META_DESCRIPTION_MASK (1L<<3)
#define SP_META_WARNING_MASK (1L<<4)
#define SP_META_RELEASE_MASK (1L<<5)
#define SP_META_COPYRIGHT_MASK (1L<<6)
#define SP_META_DISCLAIMER_MASK (1L<<7)
#define SP_META_SOURCE_MASK (1L<<8)
#define SP_META_SOFTWARE_MASK (1L<<9)
#define SP_META_SUBJECT_MASK (1L<<10)
#define SP_META_COMMENT_MASK (1L<<11)
    
typedef struct _spMetaInfo {
    unsigned long info_mask;
    spLong32 number;
    char title[SP_META_INFO_SIZE];
    char author[SP_META_INFO_SIZE];
    char description[SP_META_INFO_SIZE];
    char warning[SP_META_INFO_SIZE];
    char release[SP_META_INFO_SIZE];
    char copyright[SP_META_INFO_SIZE];
    char disclaimer[SP_META_INFO_SIZE];
    char source[SP_META_INFO_SIZE];
    char software[SP_META_INFO_SIZE];
    char subject[SP_META_INFO_SIZE];
    char comment[SP_META_INFO_SIZE];
} spMetaInfo;

#if defined(MACOS)
#pragma import on
extern void *spGetDIBitmapGWorldMac(spDIBitmap dibitmap);
#endif

extern void spDumpDIBitmapValue(spDIBitmap dibitmap);

extern spBool spIsDIBitmapSupportedByHandler(spDIBitmapHandler handler, unsigned long caps, unsigned long options, const char *filename, const char *mode);
extern spDIBitmapHandler spGetDIBitmapSupportedHandler(unsigned long caps, unsigned long options,
                                                       const char *filename, const char *mode, int *current_priority);

extern spDIBitmap spCreateDIBitmapFromFileWithOptions(const char *filename, spDIBitmapInfo *info, unsigned long options);
extern spDIBitmap spCreateDIBitmapFromFile(const char *filename);
extern spDIBitmap spCreateDIBitmapFromFileNonnative(const char *filename);
extern spDIBitmapInfo *spGetDIBitmapFileInfo(spDIBitmap dibitmap);
    
extern spDIBitmap spCreateDIBitmapWithOptions(spDIBitmapInfo *info, unsigned long options);
extern spDIBitmap spCreateDIBitmap(spDIBitmapInfo *info);
extern spBool spSaveDIBitmapWithHandler(spDIBitmapHandler handler, spDIBitmap dibitmap, const char *filename, spDIBitmapInfo *target_info, unsigned long options);
extern spBool spSaveDIBitmapWithInfo(spDIBitmap dibitmap, const char *filename, spDIBitmapInfo *target_info, unsigned long options);
extern spBool spSaveDIBitmap(spDIBitmap dibitmap, const char *filename);
extern spBool spDestroyDIBitmap(spDIBitmap dibitmap);

extern unsigned long spGetDIBitmapCaps(spDIBitmap dibitmap);
extern spDIPixelFormat spGetDIBitmapPixelFormat(spDIBitmap dibitmap);
extern spBool spIsDIBitmapTypePlugin(spDIBitmap dibitmap);
    
/* Almost all DIB functions must be called in locked state issued by spLockDIBitmap.
 * Otherwise, you will get an error in calling the functions. */
extern spBool spLockDIBitmap(spDIBitmap dibitmap);
extern spBool spUnlockDIBitmap(spDIBitmap dibitmap);

extern spBool spSetDIBitmapRGBA(spDIBitmap dibitmap, int x, int y, int r, int g, int b, int a);
extern spBool spSetDIBitmapRGB(spDIBitmap dibitmap, int x, int y, int r, int g, int b);
/* spAddDIBitmapRGB includes clipping procedure (limiting to 0-255) while spSetDIBitmapRGB doesn't. */
extern spBool spAddDIBitmapRGBA(spDIBitmap dibitmap, int x, int y, int r, int g, int b, int a);
extern spBool spAddDIBitmapRGB(spDIBitmap dibitmap, int x, int y, int r, int g, int b);
extern spBool spGetDIBitmapRGBA(spDIBitmap dibitmap, int x, int y, int *r, int *g, int *b, int *a);
extern spBool spGetDIBitmapRGB(spDIBitmap dibitmap, int x, int y, int *r, int *g, int *b);

extern spBool spCopyDIBitmapToImage(spDIBitmap dibitmap, spComponent dest, int src_x, int src_y,
				    int width, int height, int dest_x, int dest_y);
extern spBool spStretchDIBitmapToImage(spDIBitmap dibitmap, spComponent dest,
				       int src_x, int src_y, int src_width, int src_height,
				       int dest_x, int dest_y, int dest_width, int dest_height);
extern spBool spCopyImageToDIBitmap(spComponent src, spDIBitmap dibitmap, int src_x, int src_y,
				    int width, int height, int dest_x, int dest_y);
    
extern spBool spIsDIBitmapPlugin(spPlugin *plugin);
    
extern spBool spReverseDIBitmap(spDIBitmap dibitmap);
extern spBool spFlipDIBitmap(spDIBitmap dibitmap, spBool lr_flag);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPDIBITMAP_H */
    
