/*
 *	spDial.h
 */

#ifndef __SPDIAL_H
#define __SPDIAL_H

#include <sp/spComponent.h>
#include <sp/spSlider.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpDial "Dial"
    
#define SppMinimumAngle "iMinimumAngle" /* CSG */
#define SppMaximumAngle "iMaximumAngle" /* CSG */
#define SppShadowWidth "iShadowWidth" /* CG */
#define SppIndicatorSize "iIndicatorSize" /* CG */
#define SppIndicatorType "eIndicatorType" /* CG */
#define SppKnobType "eKnobType" /* CSG */

typedef enum {
    SP_DIAL_INDICATOR_CIRCLE = 0,
    SP_DIAL_INDICATOR_LINE = 1,
} spDialIndicatorType;
    
#define SP_DIAL_INDICATOR_CIRCLE_STRING "0"
#define SP_DIAL_INDICATOR_LINE_STRING "1"

typedef enum {
    SP_KNOB_TYPE_CIRCULAR = 0,
    SP_KNOB_TYPE_RELATIVE = 1,
    SP_KNOB_TYPE_LINEAR = 2,
} spKnobType;
    
#define SP_KNOB_TYPE_CIRCULAR_STRING "0"
#define SP_KNOB_TYPE_RELATIVE_STRING "1"
#define SP_KNOB_TYPE_LINEAR_STRING "2"
    

typedef struct _spDialRec *spDial;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpDialClass;
    
extern spBool spIsDial(spComponent component);
extern spComponent spCreateDial(spComponent parent, const char *name, ...);
extern spBool spSetDialValue(spComponent component, int value);
extern spBool spGetDialValue(spComponent component, int *value);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPDIAL_H */
