/*
 *	spDialog.h
 */

#ifndef __SPDIALOG_H
#define __SPDIALOG_H

#include <sp/spPrimitive.h>
#include <sp/spFrame.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpDialog "Dialog"
#define SpMessageDialog "MessageDialog"
#define SpFileDialog "FileDialog"
#define SpFontDialog "FontDialog"
#define SpColorDialog "ColorDialog"
#define SpPageSetupDialog "PageSetupDialog"
    
#define SppDialogType "eDialogType" /* CG */
#define SppMessageBoxButtonType "eMessageBoxButtonType" /* CG */
    
#define SppFileFilters "LFileFilters" /* CSG */
#define SppFileTypes "LFileTypes" /* CSG */
#define SppFileFilterIndex "PFileFilterIndex" /* CSG */

/* The way of working of the following variables depends on your environment */
#define SppInitialDir "SInitialDir" /* CSG */
#define SppInitialFileName "SInitialFileName" /* CSG */
#define SppPathMustExist "bPathMustExist" /* CSG */
#define SppFileMustExist "bFileMustExist" /* CSG */
#define SppOverwritePrompt "bOverwritePrompt" /* CSG */

#define SppInitialFont "SInitialFont" /* CSG */
#define SppInitialColor "SInitialColor" /* CSG */

/* 0.6.9+ */    
/* for setup dialog */    
#define SppPhisicalMarginLeft "dPhisicalMarginLeft" 	/* C */
#define SppPhisicalMarginRight "dPhisicalMarginRight"	/* C */
#define SppPhisicalMarginTop "dPhisicalMarginTop"   	/* C */
#define SppPhisicalMarginBottom "dPhisicalMarginBottom" /* C */
#define SppDisablePageOrientation "bDisablePageOrientation" /* C */
#define SppDisablePaperSize "bDisablePaperSize"		/* C */
/* for target dialog */    
#define SppEnablePageRange "bEnablePageRange"	/* C */
#define SppEnablePageRangeSelection "bEnablePageRangeSelection"	/* C */
#define SppEnablePageRangeCurrent "bEnablePageRangeCurrent"	/* C */
#define SppMaxPageRange "iMaxPageRange"	/* C */
#define SppCurrentPage "iCurrentPage"	/* C */

typedef enum {
    SP_MESSAGE_DIALOG = 0,
    SP_INFORMATION_DIALOG = 1,
    SP_QUESTION_DIALOG = 2,
    SP_WARNING_DIALOG = 3,
    SP_ERROR_DIALOG = 4,
    SP_WORKING_DIALOG = 5,
    SP_OPEN_FILE_DIALOG = 6,
    SP_SAVE_FILE_DIALOG = 7,
    SP_DIR_SELECTION_DIALOG = 8,
} spDialogType;

#define SP_MESSAGE_DIALOG_STRING "0"
#define SP_INFORMATION_DIALOG_STRING "1"
#define SP_QUESTION_DIALOG_STRING "2"
#define SP_WARNING_DIALOG_STRING "3"
#define SP_ERROR_DIALOG_STRING "4"
#define SP_WORKING_DIALOG_STRING "5"
#define SP_OPEN_FILE_DIALOG_STRING "6"
#define SP_SAVE_FILE_DIALOG_STRING "7"

typedef enum {
    SP_MB_OK = 0,
    SP_MB_OK_CANCEL = 1,
    SP_MB_YES_NO = 2,
    SP_MB_YES_NO_CANCEL = 3,
    SP_MB_RETRY_CANCEL = 4,
    SP_MB_OK_CANCEL_APPLY = 5,	/* for compatibility */
} spMessageBoxButtonType;

#define SP_MB_OK_STRING "0"
#define SP_MB_OK_CANCEL_STRING "1"
#define SP_MB_YES_NO_STRING "2"
#define SP_MB_YES_NO_CANCEL_STRING "3"
#define SP_MB_RETRY_CANCEL_STRING "4"
#define SP_MB_OK_CANCEL_APPLY_STRING "5"

typedef enum {
    SP_DR_NONE = -1,
    SP_DR_OK = 0,
    SP_DR_CANCEL = 1,
    SP_DR_YES = 2,
    SP_DR_NO = 3,
    SP_DR_RETRY = 4,
    SP_DR_APPLY = 5,
} spDialogResponse;

#define SP_DR_NONE_STRING "-1"
#define SP_DR_OK_STRING "0"
#define SP_DR_CANCEL_STRING "1"
#define SP_DR_YES_STRING "2"
#define SP_DR_NO_STRING "3"
#define SP_DR_RETRY_STRING "4"
#define SP_DR_APPLY_STRING "5"

/* internal use only */
typedef enum {
    SP_FD_TYPE_UNKNOWN = -1,
    SP_FD_TYPE_OPEN = 0,
    SP_FD_TYPE_SAVE = 1,
    SP_FD_TYPE_DIR = 2,
} spFileDialogType;
    
typedef struct _spDialogRec *spDialog;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpDialogClass;
    
extern spBool spIsDialog(spComponent component);
extern spDialogResponse spCreateMessageBoxArg(spComponent parent, const char *name,
                                              const char *message, spArg *args, int num_arg);
extern spDialogResponse spCreateMessageBox(spComponent parent, const char *name,
					   const char *message, ...);
extern void spDisplayError(spComponent parent, const char *title, const char *format, ...);
extern void spDisplayWarning(spComponent parent, const char *title, const char *format, ...);
extern void spDisplayMessage(spComponent parent, const char *title, const char *format, ...);
extern void spDisplayInformation(spComponent parent, const char *title, const char *format, ...);
extern void spDisplayErrorCB(spComponent component, const char *message);
extern void spDisplayWarningCB(spComponent component, const char *message);
extern void spDisplayMessageCB(spComponent component, const char *message);
extern void spDisplayInformationCB(spComponent component, const char *message);
extern char *xspGetOpenFileName(spComponent parent, const char *name, ...);
extern char *xspGetSaveFileName(spComponent parent, const char *name, ...);
extern char *xspGetSelectedDirName(spComponent parent, const char *name, ...);

extern char *xspChooseFont(spComponent parent, const char *name, ...);
extern char *xspChooseColor(spComponent parent, const char *name, ...);

extern spBool spDisplayHelp(spComponent component, const char *path);	/* if path is NULL, show component help */

extern spBool spGetPageSetup(spComponent parent, spPaperSize *paper_size, spPaperOrientation *paper_orientation,
			     double *left_margin_mm, double *right_margin_mm, double *top_margin_mm, double *bottom_margin_mm,
			     ...);
    
/* internal use only */
extern char *xspPopupFileSelectionBoxArg(spComponent parent, const char *name,
					 spFileDialogType dialog_type,
					 spArg *args, int num_arg);
extern char *xspChooseFontArch(spComponent component);
extern char *xspChooseColorArch(spComponent component);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPDIALOG_H */
