/*
 *	spDialogBox.h
 */

#ifndef __SPDIALOGBOX_H
#define __SPDIALOGBOX_H

#include <sp/spComponent.h>
#include <sp/spDialog.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpDialogBox "DialogBox"

typedef struct _spDialogBoxRec *spDialogBox;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpDialogBoxClass;
    
extern spBool spIsDialogBox(spComponent component);
extern spComponent spCreateDialogBox(const char *name, ...);
extern void spGetOptionDialogData(spComponent component);
extern void spPopdownOptionDialogCB(spComponent component, void *data);
extern spComponent spCreateOptionDialog(const char *name, spOptions options, ...);

/* 0.6.15+ */    
extern void spGetOptionParamFieldsData(spComponent parent); 
extern void spResetOptionParamFieldsData(spComponent parent);
extern void spResetOptionDialogData(spComponent component);
extern spBool spCreateOptionParamFields(spComponent parent, spOptions options);
extern spComponent spFindOptionParamField(spComponent parent, spOption *option);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPDIALOGBOX_H */
