/*
 *	spDraw.h
 */

#ifndef __SPDRAW_H
#define __SPDRAW_H

#include <sp/spComponent.h>
#include <sp/spGraphics.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SP_PAGE_RANGE_ALL -2
#define SP_PAGE_RANGE_SELECTION -3
#define SP_PAGE_RANGE_CURRENT -4
    
#define SP_DRAWING_CAPS_NO_TARGET_DIALOG (1L<<0)	/* function exists, but dialog unsupported */
#define SP_DRAWING_CAPS_NO_SETUP_DIALOG (1L<<1)		/* function exists, but dialog unsupported */
#define SP_DRAWING_CAPS_SIZE_FLEXIBLE (1L<<2) 		/* accept any size */
#define SP_DRAWING_CAPS_NOT_NEED_TARGET_DIALOG (1L<<3) 	/* does work without calling target dialog */    
#define SP_DRAWING_CAPS_MULTIPLE_PAGES (1L<<4)

#define SP_DRAWING_CAPS_MONO_ONLY (1L<<5)
#define SP_DRAWING_CAPS_SCALING (1L<<6)
#define SP_DRAWING_CAPS_COPY_IMAGE (1L<<7)
#define SP_DRAWING_CAPS_COPY_IMAGE_STRETCHABLE (1L<<8)
#define SP_DRAWING_CAPS_DRAW_LINE (1L<<9)
#define SP_DRAWING_CAPS_FILL_RECTANGLE (1L<<10)
#define SP_DRAWING_CAPS_DRAW_RECTANGLE (1L<<11)
#define SP_DRAWING_CAPS_FILL_ARC (1L<<12)
#define SP_DRAWING_CAPS_DRAW_ARC (1L<<13)
#define SP_DRAWING_CAPS_FILL_POLYGON (1L<<14)
#define SP_DRAWING_CAPS_DRAW_POLYGON (1L<<15)
#define SP_DRAWING_CAPS_STRING_EXTENT (1L<<16)
#define SP_DRAWING_CAPS_STRING_EXTENT_ACCURATE (1L<<17)
#define SP_DRAWING_CAPS_STRING_ROTATION (1L<<18)
#define SP_DRAWING_CAPS_DRAW_WIDE_LINE (1L<<20)
#define SP_DRAWING_CAPS_DRAW_STYLED_LINE (1L<<21)
#define SP_DRAWING_CAPS_DRAW_WIDE_STYLED_LINE (1L<<22)
#define SP_DRAWING_CAPS_DRAW_WIDE_RECTANGLE (1L<<23)
#define SP_DRAWING_CAPS_DRAW_STYLED_RECTANGLE (1L<<24)
#define SP_DRAWING_CAPS_DRAW_WIDE_STYLED_RECTANGLE (1L<<25)
#define SP_DRAWING_CAPS_DRAW_WIDE_ARC (1L<<26)
#define SP_DRAWING_CAPS_DRAW_STYLED_ARC (1L<<27)
#define SP_DRAWING_CAPS_DRAW_WIDE_STYLED_ARC (1L<<28)
#define SP_DRAWING_CAPS_DRAW_WIDE_POLYGON (1L<<29)
#define SP_DRAWING_CAPS_DRAW_STYLED_POLYGON (1L<<30)
#define SP_DRAWING_CAPS_DRAW_WIDE_STYLED_POLYGON (1L<<31)
    
typedef unsigned long spDrawingDeviceType;
#define SP_DRAWING_DEVICE_NONE 0
#define SP_DRAWING_DEVICE_UNKNOWN 0
#define SP_DRAWING_DEVICE_DISPLAY (1L<<0)
#define SP_DRAWING_DEVICE_PRINTER (1L<<1)
#define SP_DRAWING_DEVICE_FILE (1L<<2)
    
typedef struct _spPolygon *spPolygon;

#if defined(MACOS)
#pragma import on
#endif

extern spBool spIsAlphaSupported(spComponent component);
extern spBool spIsDrawable(spComponent component);
extern spBool spCopyImage(spComponent src, spComponent dest,
			  int src_x, int src_y, int width, int height,
			  int dest_x, int dest_y);
extern spBool spStretchImage(spComponent src, spComponent dest,
			     int src_x, int src_y, int src_width, int src_height,
			     int dest_x, int dest_y, int dest_width, int dest_height);
extern void spFillRectangle(spComponent component, spGraphics graphics,
			    int x, int y, int width, int height);
extern void spDrawRectangle(spComponent component, spGraphics graphics,
			    int x, int y, int width, int height);
/* angle1: start degree, angle2: size degree */
extern void spFillArc(spComponent component, spGraphics graphics,
		      int x, int y, int width, int height, double angle1, double angle2);
extern void spDrawArc(spComponent component, spGraphics graphics,
		      int x, int y, int width, int height, double angle1, double angle2);
extern void spDrawLine(spComponent component, spGraphics graphics,
		       int x1, int y1, int x2, int y2);
extern void spDrawPoint(spComponent component, spGraphics graphics,
			int x, int y);
extern void spDrawString(spComponent component, spGraphics graphics,
			 int x, int y, const char *string);
extern spBool spGetStringExtent(spComponent component, spGraphics graphics, const char *string,
				int *x, int *y, int *width, int *height, int *next_x);

extern spPolygon spCreatePolygon(int max_points);
extern spBool spDestroyPolygon(spPolygon polygon);
extern spBool spStartPolygonPoint(spPolygon polygon, int x, int y);
extern spBool spAddPolygonPoint(spPolygon polygon, int x, int y);
extern spBool spAddPolygonRelativePoint(spPolygon polygon, int dx, int dy);
extern spBool spEndPolygonPoint(spPolygon polygon);
extern spBool spMovePolygon(spPolygon polygon, int dx, int dy);
extern spBool spFillPolygon(spComponent component, spGraphics graphics, spPolygon polygon);
/* spDrawPolygon on Mac maybe ignores line type. To check this, call spGetGraphicsCaps. */
extern spBool spDrawPolygon(spComponent component, spGraphics graphics, spPolygon polygon);

extern spBool spOpenDrawingSetupDialogArg(spComponent component, spArg *args, int num_arg);
extern spBool spOpenDrawingSetupDialog(spComponent component, ...);
extern spBool spSetPageRange(spComponent component, int start_page, int end_page, int max_page);
extern spBool spGetPageRange(spComponent component, int *start_page, int *end_page);
extern spBool spOpenDrawingTargetDialogArg(spComponent component, spArg *args, int num_arg);
extern spBool spOpenDrawingTargetDialog(spComponent component, ...);
extern spBool spCloseDrawingTarget(spComponent component);

/* the following spGet* functions must be called after spOpenDrawing* */
extern unsigned long spGetDrawingCaps(spComponent component);
extern unsigned long spGetGraphicsCaps(spComponent component);
extern unsigned long spGetSystemDrawingCaps(void);
extern unsigned long spGetSystemGraphicsModeCaps(void);
extern spBool spGetPhysicalSize(spComponent component, double *width_mm, double *height_mm);
/* spSetScalingFactor must be called before spStartDrawing */
extern spBool spSetScalingFactor(spComponent component, double xfactor, double yfactor);
extern spBool spSetNumPage(spComponent component, int num_page);
extern int spGetNumPage(spComponent component);
extern spBool spStartDrawing(spComponent component, const char *job_name);
extern spBool spEndDrawing(spComponent component);
extern spBool spForwardPage(spComponent component);
extern spBool spSetCurrentPage(spComponent component, int current_page);
extern int spGetCurrentPage(spComponent component); /* 1-based page number */

extern spBool spIsPrintCanvas(spComponent component);
extern spComponent spCreatePrintCanvas(spComponent parent, ...);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPDRAW_H */
