/*
 *	spDrawingPlugin.h
 */

#ifndef __SPDRAWINGPLUGIN_H
#define __SPDRAWINGPLUGIN_H

#include <sp/spBase.h>
#include <sp/spPlugin.h>
#include <sp/spComponent.h>
#include <sp/spGraphics.h>
#include <sp/spDialog.h>
#include <sp/spDraw.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SP_PLUGIN_DRAWING "drawing 1.1"

#define SP_DRAWING_PLUGIN_PRINTER "Printer"
#define SP_DRAWING_PLUGIN_PS "Postscript"
#define SP_DRAWING_PLUGIN_EMF "EMF"

#define SP_DRAWING_PLUGIN_CAPS_NOT_NEED_TARGET (1<<(SP_PLUGIN_CAPS_USER_SHIFT)) 
#define SP_DRAWING_PLUGIN_CAPS_GENERAL_SETUP_DIALOG_UNACCEPTABLE (1<<(SP_PLUGIN_CAPS_USER_SHIFT+1)) 
#define SP_DRAWING_PLUGIN_CAPS_GENERAL_SETUP_DIALOG_NOT_RECOMMENDED (1<<(SP_PLUGIN_CAPS_USER_SHIFT+2)) 
#define SP_DRAWING_PLUGIN_CAPS_CALLBACK_DRAW (1<<(SP_PLUGIN_CAPS_USER_SHIFT+3)) 
#define SP_DRAWING_PLUGIN_CAPS_MULTIPLE_PAGES (1<<(SP_PLUGIN_CAPS_USER_SHIFT+4)) 
  
typedef struct _spDrawingPluginRec spDrawingPluginRec;
    
#if defined(MACOS)
#pragma import on
#endif

extern const char *spSearchDrawingPluginFile(int index, spDrawingDeviceType device_type);
extern char *xspSearchDrawingPluginFile(int index, spDrawingDeviceType device_type);
extern const char *spGetDrawingPluginDescription(const char *plugin_name);
extern char *xspGetDrawingPluginDescription(const char *plugin_name);
extern const char *spGetDrawingPluginInformation(const char *plugin_name);
extern char *xspGetDrawingPluginInformation(const char *plugin_name);
extern spBool spIsDrawingPlugin(spPlugin *plugin);
extern spDrawingDeviceType spGetPluginDrawingDeviceType(spPlugin *plugin);
    
extern spBool spAddPrinterPlugin(void);
extern spBool spRemovePrinterPlugin(void);
extern spBool spAddPSPlugin(void);
extern spBool spRemovePSPlugin(void);
extern spBool spAddDefaultDrawingPlugin(void);
extern spBool spRemoveDefaultDrawingPlugin(void);
#if defined(_WIN32)
extern spBool spAddEmfPlugin(void);
extern spBool spRemoveEmfPlugin(void);
#endif

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPDRAWINGPLUGIN_H */
