/*
 *	spFrame.h
 */

#ifndef __SPFRAME_H
#define __SPFRAME_H

#include <sp/spTopLevel.h>
#include <sp/spPrimitive.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpFrame "Frame"
#define SpMainFrame "MainFrame"
    
#define SppIconName "SIconName"	/* CSG */
#define SppPopupStyle "ePopupStyle" /* CG */
#define SppCloseStyle "eCloseStyle" /* CSG */
#define SppWindowType "eWindowType" /* CG */
#define SppResizable "bResizable" /* CG */
#define SppIconfiable "bIconfiable" /* CG */
#define SppSimplifiable "bSimplifiable" /* CG */
#define SppInternalWindow "bInternalWindow" /* CG */
#define SppParentWindow "PParentWindow" /* CG */
#define SppTaskTrayVisible "bTaskTrayVisible" /* CSG */
#define SppTaskTrayIcon "STaskTrayIcon" /* CSG */
#define SppTaskTrayTip "STaskTrayTip" /* CSG */
#define SppDialogBoxButtonType "eDialogBoxButtonType" /* CG */

/* 0.6.6+ */
#define SppHelpButtonVisible "bHelpButtonVisible" /* CG */
/* 0.6.7+ */
#define SppSystemWindow "PSystemWindow" /* CG */
/* if the system window exists, creating a menu bar in the window will be illegal. */
#define SppInitialX "iInitialX" /* C */
#define SppInitialY "iInitialY" /* C */
    
/* 0.6.10+ */
#define SppTopMost "bTopMost" /* CSG; currently Windows only */
    
/* 0.6.13+ */
#define SppFrameButtonType "eDialogBoxButtonType" /* same as SppDialogBoxButtonType */

typedef enum {
    SP_MODELESS_POPUP = 0,
    SP_MODAL_POPUP = 1,
    SP_SYSTEM_MODAL_POPUP = 2,	/* not implemented yet */
    SP_WINDOW_MODAL_POPUP = 3,	/* not implemented yet */
} spPopupStyle;

#define SP_MODELESS_POPUP_STRING "0"
#define SP_MODAL_POPUP_STRING "1"
#define SP_SYSTEM_MODAL_POPUP_STRING "2"
#define SP_WINDOW_MODAL_POPUP_STRING "3"

typedef enum {
    SP_NO_CLOSE = 0,
    SP_UNMAP_CLOSE = 1,
    SP_DESTROY_CLOSE = 2,
    SP_CALLBACK_CLOSE = 3,
} spCloseStyle;
    
#define SP_NO_CLOSE_STRING "0"
#define SP_UNMAP_CLOSE_STRING "1"
#define SP_DESTROY_CLOSE_STRING "2"
#define SP_CALLBACK_CLOSE_STRING "3"

typedef enum {
    SP_NORMAL_WINDOW = 0,
    SP_DIALOG_WINDOW = 1,
    SP_TRANSIENT_WINDOW = 2,
    SP_FULLSCREEN_WINDOW = 3,
} spWindowType;

#define SP_NORMAL_WINDOW_STRING "0"
#define SP_DIALOG_WINDOW_STRING "1"
#define SP_TRANSIENT_WINDOW_STRING "2"
#define SP_FULLSCREEN_WINDOW_STRING "3"

typedef enum {
    SP_DB_NONE = -1,
    SP_DB_OK = 0,
    SP_DB_OK_CANCEL = 1,
    SP_DB_YES_NO = 2,
    SP_DB_YES_NO_CANCEL = 3,
    SP_DB_RETRY_CANCEL = 4,
    SP_DB_OK_CANCEL_APPLY = 5,
} spDialogBoxButtonType;

#define SP_DB_NONE_STRING "-1"
#define SP_DB_OK_STRING "0"
#define SP_DB_OK_CANCEL_STRING "1"
#define SP_DB_YES_NO_STRING "2"
#define SP_DB_YES_NO_CANCEL_STRING "3"
#define SP_DB_RETRY_CANCEL_STRING "4"
#define SP_DB_OK_CANCEL_APPLY_STRING "5"

    
typedef struct _spFrameRec *spFrame;

typedef void (*spDrawFunc)(void *call_data, int x, int y, int width, int height);
typedef spLong (*spMouseFunc)(void *call_data, int x, int y);
typedef spLong (*spKeyFunc)(void *call_data, long keycode);
typedef void (*spForegroundFunc)(void *call_data);
typedef void (*spBackgroundFunc)(void *call_data);

typedef struct _spTimerList *spTimerList;
    
#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpFrameClass;

extern spBool spIsFrame(spComponent component);
extern spBool spIsMainFrame(spComponent component);
extern spComponent spCreateFrame(const char *name, ...);
extern spComponent spCreateMainFrame(const char *name, ...);
extern spBool spIsTaskTraySupported(void);
extern spTopLevel spGetTopLevel(spComponent component);
extern spBool spIsFrameToolBarVisible(spComponent component);
extern spBool spIsFrameStatusBarVisible(spComponent component);

/* If the callback function returns SP_FALSE, the system will call spKillTimer automatically.
 * So, don't call spKillTimer in your function in this case. */
extern spTimerId spSetTimer(spComponent frame, long interval_ms,
			    spTimerCallbackFunc call_func, void *call_data);
extern spBool spKillTimer(spComponent frame, spTimerId timer_id);

/* Currently, only single drop callback is accepted. */
extern spBool spAddDropCallback(spComponent frame, spDropCallbackFunc call_func, void *call_data);
extern spBool spRemoveDropCallback(spComponent frame, spDropCallbackFunc call_func, void *call_data);

extern void spAddFrameCallback(spComponent frame, spDrawFunc draw_func,
			       spMouseFunc mouse_func, spKeyFunc key_func,
			       spForegroundFunc foreground_func, spBackgroundFunc background_func, 
			       void *data);

/* 0.6.21+, internal use only */
extern spBool spSetTaskTrayMenu(spComponent frame, spComponent menu);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPFRAME_H */
