/*
 *	spGraphics.h
 */

#ifndef __SPGRAPHICS_H
#define __SPGRAPHICS_H

#include <sp/spObject.h>
#include <sp/spLabel.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpGraphics "Graphics"
    
#define SppLineType "eLineType"	/* CSG   spLineType */
#define SppLineWidth "iLineWidth" /* CSG  */
#define SppGraphicsMode "eGraphicsMode" /* CSG   spGraphicsMode */
#define SppForegroundPixel "lForegroundPixel" /* CSG */
#define SppBackgroundPixel "lBackgroundPixel" /* CSG */

/* 0.6.9+ */    
#define SppStringAlignment "eStringAlignment"	/* CSG   spAlignment */
#define SppStringRotation "iStringRotation"	/* CSG */
#define SppStringRotationFailedAlignment "eStringRotationFailedAlignment"	/* CSG   spAlignment */

/* 0.6.13+ */    
#define SppUseAntiAliasDraw "bUseAntiAliasDraw"	/* CSG  default:SP_FALSE */
#define SppUseAntiAliasFont "bUseAntiAliasFont"	/* CSG  default:SP_TRUE */

typedef enum {
    SP_SYSTEM_COLOR_NONE = -1,
    SP_SYSTEM_COLOR_BACKGROUND = 0,
    SP_SYSTEM_COLOR_TOP_SHADOW = 1,
    SP_SYSTEM_COLOR_BOTTOM_SHADOW = 2,
    SP_SYSTEM_COLOR_BLACK = 3,
    SP_SYSTEM_COLOR_WHITE = 4,
    SP_SYSTEM_COLOR_HIGHLIGHT = 5,
    SP_SYSTEM_COLOR_DARK_SHADOW = 6,
    SP_SYSTEM_COLOR_FOCUS = 7,
    SP_SYSTEM_COLOR_TAB_BACKGROUND = 8,
    SP_SYSTEM_COLOR_PROGRESS_BAR = 9,
    SP_SYSTEM_COLOR_LABEL_STRING = 10,
} spSystemColorType;

#define SP_SYSTEM_COLOR_SHADOW SP_SYSTEM_COLOR_BOTTOM_SHADOW

typedef enum {
    SP_LINE_NONE = -1,
    SP_LINE_SOLID = 0,
    SP_LINE_DASH = 1,
    SP_LINE_DOT = 2,
    SP_LINE_DASH_DOT = 3,
    SP_LINE_DASH_DOT_DOT = 4,
} spLineType;

#define SP_LINE_NONE_STRING "-1"
#define SP_LINE_SOLID_STRING "0"
#define SP_LINE_DASH_STRING "1"
#define SP_LINE_DOT_STRING "2"
#define SP_LINE_DASH_DOT_STRING "3"
#define SP_LINE_DASH_DOT_DOT_STRING "4"


#define SP_FONT_SLANT_ROMAN (1L<<0)
#define SP_FONT_SLANT_ITALIC (1L<<1)
#define SP_FONT_SLANT_OBLIQUE (1L<<2)
#define SP_FONT_WEIGHT_LIGHT (1L<<4)
#define SP_FONT_WEIGHT_MEDIUM (1L<<5)
#define SP_FONT_WEIGHT_BOLD (1L<<6)
#define SP_FONT_WEIGHT_BLACK (1L<<7)
#define SP_FONT_WIDTH_NORMAL (1L<<12)
#define SP_FONT_WIDTH_CONDENSED (1L<<13)
#define SP_FONT_WIDTH_NARROW (1L<<14)
#define SP_FONT_WIDTH_EXTENDED (1L<<15)
#define SP_FONT_PITCH_FIXED (1L<<16)
#define SP_FONT_PITCH_CELL (1L<<17)
#define SP_FONT_PITCH_VARIABLE (1L<<18)

#define SP_FONT_STYLE_MEDIUM (SP_FONT_SLANT_ROMAN | SP_FONT_WEIGHT_MEDIUM)
#define SP_FONT_STYLE_ITALIC (SP_FONT_SLANT_ITALIC | SP_FONT_WEIGHT_MEDIUM)
#define SP_FONT_STYLE_OBLIQUE (SP_FONT_SLANT_OBLIQUE | SP_FONT_WEIGHT_MEDIUM)
#define SP_FONT_STYLE_BOLD (SP_FONT_SLANT_ROMAN | SP_FONT_WEIGHT_BOLD)
#define SP_FONT_STYLE_BOLD_ITALIC (SP_FONT_SLANT_ITALIC | SP_FONT_WEIGHT_BOLD)
#define SP_FONT_STYLE_BOLD_OBLIQUE (SP_FONT_SLANT_OBLIQUE | SP_FONT_WEIGHT_BOLD)
#define SP_FONT_STYLE_LIGHT (SP_FONT_SLANT_ROMAN | SP_FONT_WEIGHT_LIGHT)
#define SP_FONT_STYLE_LIGHT_ITALIC (SP_FONT_SLANT_ITALIC | SP_FONT_WEIGHT_LIGHT)
#define SP_FONT_STYLE_LIGHT_OBLIQUE (SP_FONT_SLANT_OBLIQUE | SP_FONT_WEIGHT_LIGHT)
#define SP_FONT_STYLE_BLACK (SP_FONT_SLANT_ROMAN | SP_FONT_WEIGHT_BLACK)
#define SP_FONT_STYLE_BLACK_ITALIC (SP_FONT_SLANT_ITALIC | SP_FONT_WEIGHT_BLACK)
#define SP_FONT_STYLE_BLACK_OBLIQUE (SP_FONT_SLANT_OBLIQUE | SP_FONT_WEIGHT_BLACK)

#define SP_GRAPHICS_MODE_CAPS_COPY 0L
#define SP_GRAPHICS_MODE_CAPS_XOR (1L<<0)
#define SP_GRAPHICS_MODE_CAPS_INVERT (1L<<1)
#define SP_GRAPHICS_MODE_CAPS_AND (1L<<2)
#define SP_GRAPHICS_MODE_CAPS_OR (1L<<3)

#define SP_GRAPHICS_MODE_CAPS_SOURCE_OVER (1L<<4)
#define SP_GRAPHICS_MODE_CAPS_SOURCE_IN (1L<<5)
#define SP_GRAPHICS_MODE_CAPS_SOURCE_OUT (1L<<6)
#define SP_GRAPHICS_MODE_CAPS_SOURCE_ATOP (1L<<7)
#define SP_GRAPHICS_MODE_CAPS_DEST_OVER (1L<<8)
#define SP_GRAPHICS_MODE_CAPS_DEST_IN (1L<<9)
#define SP_GRAPHICS_MODE_CAPS_DEST_OUT (1L<<10)
#define SP_GRAPHICS_MODE_CAPS_DEST_ATOP (1L<<11)
#define SP_GRAPHICS_MODE_CAPS_PORTER_DUFF_XOR (1L<<12)
#define SP_GRAPHICS_MODE_CAPS_PLUS_DARKER (1L<<13)
#define SP_GRAPHICS_MODE_CAPS_PLUS_LIGHTER (1L<<14)
#define SP_GRAPHICS_MODE_CAPS_SATURATE (1L<<15)
    
#define SP_GRAPHICS_MODE_CAPS_MULTIPLY (1L<<16)
#define SP_GRAPHICS_MODE_CAPS_SCREEN (1L<<17)
#define SP_GRAPHICS_MODE_CAPS_OVERLAY (1L<<18)
#define SP_GRAPHICS_MODE_CAPS_DARKEN (1L<<19)
#define SP_GRAPHICS_MODE_CAPS_LIGHTEN (1L<<20)

#define SP_GRAPHICS_MODE_CAPS_COLOR_DODGE (1L<<21)
#define SP_GRAPHICS_MODE_CAPS_COLOR_BURN (1L<<22)
#define SP_GRAPHICS_MODE_CAPS_HARD_LIGHT (1L<<23)
#define SP_GRAPHICS_MODE_CAPS_SOFT_LIGHT (1L<<24)
#define SP_GRAPHICS_MODE_CAPS_DIFFERENCE (1L<<25)
#define SP_GRAPHICS_MODE_CAPS_EXCLUSION (1L<<26)

#define SP_GRAPHICS_MODE_CAPS_HSL_HUE (1L<<27)
#define SP_GRAPHICS_MODE_CAPS_HSL_SATURATION (1L<<28)
#define SP_GRAPHICS_MODE_CAPS_HSL_COLOR (1L<<29)
#define SP_GRAPHICS_MODE_CAPS_HSL_LUMINOSITY (1L<<30)
    
    
typedef unsigned long spPixel;
#define spRGB(r,g,b) ((spPixel)(((unsigned char)(r)|((unsigned short)((unsigned char)(g))<<8))|(((unsigned long)(unsigned char)(b))<<16)))
#define spGetRValue(pixel) ((unsigned char)(pixel))
#define spGetGValue(pixel) ((unsigned char)(((unsigned short)(pixel))>>8))
#define spGetBValue(pixel) ((unsigned char)((pixel)>>16))

typedef struct _spCursor *spCursor;
typedef struct _spGraphicsRec *spGraphics;

#if defined(MACOS)
#pragma import on
#endif

extern spObjectClass SpGraphicsClass;
    
extern spPixel spGetColorPixel(const char *color_name);
extern spBool spGetColorName(spPixel pixel, char *color_name);
extern void spGetRGB(spPixel pixel, unsigned char *r, unsigned char *g, unsigned char *b);
extern spCursor spGetCursor(spCursorType cursor_type);
extern void spDestroyCursor(spCursor cursor);
extern spGraphics spAllocGraphics(const char *name);
extern spGraphics spFindGraphics(const char *name);
extern spGraphics spCreateGraphicsArg(const char *name, spArg *args, int num_arg);
extern spGraphics spCreateGraphics(const char *name, ...);
extern void spFreeGraphics(spGraphics graphics);
extern spBool spSetGraphicsParams(spGraphics graphics, ...);
extern spBool spGetGraphicsParams(spGraphics graphics, ...);
extern spBool spSetGraphicsMode(spGraphics graphics, spGraphicsMode mode);
extern spBool spSetFont(spGraphics graphics, const char *font_name);
extern spBool spGetSystemColorPixel(spSystemColorType type, spPixel *pixel);
extern spGraphics spCreateSystemGraphics(spSystemColorType type);
extern spGraphics spGetSystemGraphics(spSystemColorType type);

extern spBool spSetForegroundPixel(spGraphics graphics, spPixel pixel);
extern spBool spSetBackgroundPixel(spGraphics graphics, spPixel pixel);
extern spPixel spGetForegroundPixel(spGraphics graphics);
extern spPixel spGetBackgroundPixel(spGraphics graphics);

extern spBool spParseFontName(const char *font_name, char *family_name, unsigned long *style, int *size);
extern spBool spGetFontName(char *font_name, const char *family_name, unsigned long style, int size);
    
extern void spHslToRgb(double  h, double  s, double  l,
		       double *r, double *g, double *b);
extern void spRgbToHsl(double r, double g, double b,
		       double *h, double *s, double *l);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGRAPHICS_H */


