/*
 *	spImage.h
 */

#ifndef __SPIMAGE_H
#define __SPIMAGE_H

#include <sp/spDraw.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpImage "Image"
    
#define SP_DEFAULT_IMAGE_WIDTH 256
#define SP_DEFAULT_IMAGE_HEIGHT 256

#if defined(MACOS)
#pragma import on
#endif

extern spBool spIsImage(spComponent component);
extern spComponent spCreateImage(spComponent parent, const char *name,
				 int width, int height, ...);
extern spComponent spCreateImageFromFile(spComponent parent, const char *filename, ...);
extern void spDrawImage(spComponent component);
extern void spRedrawImage(spComponent component, int width, int height);
extern void spResizeImage(spComponent component, int width, int height);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPIMAGE_H */
