/*
 *	spLabel.h
 */

#ifndef __SPLABEL_H
#define __SPLABEL_H

#include <sp/spPrimitive.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpLabel "Label"
    
#define SppAlignment "eAlignment" /* CG */


typedef enum {
    SP_ALIGNMENT_DYNAMIC = -1,
    SP_ALIGNMENT_BEGINNING = 0,
    SP_ALIGNMENT_CENTER = 1,
    SP_ALIGNMENT_END = 2,
#if 0
    SP_ALIGNMENT_BASELINE_TOP = 3,
    SP_ALIGNMENT_BASELINE_BOTTOM = 4,
#endif
} spAlignment;

#define SP_ALIGNMENT_BEGINNING_STRING "0"
#define SP_ALIGNMENT_CENTER_STRING "1"
#define SP_ALIGNMENT_END_STRING "2"
#if 0
#define SP_ALIGNMENT_BASELINE_TOP_STRING "3"
#define SP_ALIGNMENT_BASELINE_BOTTOM_STRING "4"
#endif

    
typedef struct _spLabelRec *spLabel;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpLabelClass;
    
extern spBool spIsLabel(spComponent component);
extern spComponent spCreateLabel(spComponent parent, char *name, ...);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPLABEL_H */
