/*
 *	spList.h
 */

#ifndef __SPLIST_H
#define __SPLIST_H

#include <sp/spPrimitive.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpList "List"
    
#define SppListStrings "LListStrings" /* CSG */
#define SppSelectedListIndex "iSelectedListIndex" /* C */
    
typedef struct _spListRec *spList;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpListClass;
    
extern spBool spIsList(spComponent component);
extern spComponent spCreateList(spComponent parent, const char *name, ...);
extern int spAddListItem(spComponent component, const char *item);
extern int spAddListIndex(spComponent component, const char *item, int index);
extern int spDeleteListItem(spComponent component, const char *item);
extern int spDeleteListIndex(spComponent component, int index);
extern int spReplaceListIndex(spComponent component, const char *item, int index);
extern spBool spClearList(spComponent component);
extern int spFindListItem(spComponent component, const char *item);
extern int spSelectListItem(spComponent component, const char *item);
extern int spSelectListIndex(spComponent component, int index);
extern char *xspGetSelectedListItem(spComponent component);
extern int spGetSelectedListIndex(spComponent component);
extern char *xspGetListItem(spComponent component, int index);
extern int spGetNumListItem(spComponent component);
extern int spUpListIndex(spComponent component, int index);
extern int spDownListIndex(spComponent component, int index);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPLIST_H */
