/*
 *	spLocale.h
 */

#ifndef __SPLOCALE_H
#define __SPLOCALE_H

#include <sp/spStringDefs.h>
#include <sp/spObject.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(MACOS)
#pragma import on
#endif

extern const char *spSetLanguage(const char *lang);
extern const char *spGetLanguage(void);
extern const char *spSetInternalLanguage(const char *lang);
extern const char *spGetInternalLanguage(void);
extern void spSetStringTable(const char *lang, spStringTable *string_table);
extern void spUpdateStringTable(void);
extern spBool spSupportLocale(const char *lang);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPLOCALE_H */
