/*
 *	spLocaleDefs.h
 */

#ifndef __SPLOCALEDEFS_H
#define __SPLOCALEDEFS_H

#include <sp/spStringDefs.h>
#include <sp/spStringDefs_C.h>
#include <sp/spStringDefs_SJIS.h>
#include <sp/spStringDefs_EUCJP.h>
#if defined(_WIN32) || defined(SP_SUPPORT_UTF8_STRING)
#include <sp/spStringDefs_UTF8JP.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _spLocaleTable {
    char *lang;
    spStringTable *string_table;
} spLocaleTable;

static spLocaleTable sp_locale_tables[] = {
#if defined(_WIN32) || defined(SP_SUPPORT_UTF8_STRING)
    {"ja_JP.utf8", sp_string_table_utf8jp},
#endif
    {"ja_JP.SJIS", sp_string_table_sjis},
    {"ja_JP.eucJP", sp_string_table_eucjp},
    {"C", sp_string_table_c},
    {NULL, NULL},
};

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif
    
#endif /* __SPLOCALEDEFS_H */
