/*
 *	spMenu.h
 */

#ifndef __SPMENU_H
#define __SPMENU_H

#include <sp/spPrimitive.h>
#include <sp/spButton.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpMenu "Menu"
#define SpMenuBar "MenuBar"
#define SpPulldownMenu "PulldownMenu"
#define SpPopupMenu "PopupMenu"
    
#define SppMenuTearOff "bMenuTearOff" /* CG */
#define SppMenuHelp "bMenuHelp"	/* CG */
#define SppPopupButton "ePopupButton" /* CSG */

/* internal use only */
#define SppTaskTrayMenu "bTaskTrayMenu"	/* CG */
    
typedef struct _spMenuRec *spMenu;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpMenuClass;
    
extern spBool spIsMenu(spComponent component);
extern spBool spIsMenuBar(spComponent component);
extern spBool spIsSubMenu(spComponent component);
extern spBool spIsHelpMenu(spComponent component);
extern spComponent spCreateMenuBar(spComponent parent, const char *name, ...);
extern spComponent spCreatePulldownMenu(spComponent parent, const char *name, ...);
extern spComponent spCreatePopupMenu(spComponent parent, const char *name, ...);
extern spComponent spCreateTaskTrayPopup(spComponent parent, const char *name, ...);
extern spComponent spAddSubMenu(spComponent parent, const char *name, ...);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPMENU_H */
