/*
 *	spMenuItem.h
 */

#ifndef __SPMENUITEM_H
#define __SPMENUITEM_H

#include <sp/spButton.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SP_QUIT_MENU_ITEM_NAME "Quit"
#define SP_QUIT_MENU_SEPARATOR_NAME "QuitSeparator"
    
/* version 0.6.12+ */    
#define SP_ABOUT_MENU_ITEM_NAME "About"
#define SP_ABOUT_MENU_SEPARATOR_NAME "AboutSeparator"

#define SpMenuItem "MenuItem"
#define SpCheckBoxMenuItem "CheckBoxMenuItem"
#define SpRadioButtonMenuItem "RadioButtonMenuItem"
#define SpMenuSeparator "MenuSeparator"
    
#define SppShortcut "SShortcut"	/* CG */

/* version 0.6.12+ */    
#define SppInformationMenuItem "bInformationMenuItem"	/* CG */
#define SppPreferenceMenuItem "bPreferenceMenuItem"	/* CG */

typedef struct _spMenuItemRec *spMenuItem;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpMenuItemClass;
    
extern spBool spIsMenuItem(spComponent component);
extern spBool spIsCheckBoxMenuItem(spComponent component);
extern spBool spIsRadioButtonMenuItem(spComponent component);
extern spBool spIsMenuSeparator(spComponent component);
extern spComponent spAddMenuItem(spComponent parent, const char *name, ...);
extern spComponent spAddCheckBoxMenuItem(spComponent parent, const char *name, ...);
extern spComponent spAddRadioButtonMenuItem(spComponent parent, const char *name, ...);
extern spComponent spAddMenuSeparator(spComponent parent, const char *name, ...);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPMENUITEM_H */
