/*
 *	spObject.h
 */

#ifndef __SPOBJECT_H
#define __SPOBJECT_H

#include <sp/spBase.h>
#include <sp/spComponentDefs.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SppName "SName"		/* CSG */
    
typedef struct _spObjectRec *spObject;
typedef struct _spObjectClassRec *spObjectClass;

typedef void *(*spAllocateFunc)(const char *class_name, const char *object_name);
typedef void (*spFreeFunc)(void *object);

#if defined(MACOS)
#pragma import on
#endif

extern spBool spNoParam(spParam param);
extern spBool spEqParam(spParam param1, spParam param2);
extern spParamType spGetParamType(spParam param);
extern spBool spIsObjectCreated(spObject object);
extern spBool spSetObjectParamsArg(spObject object, spArg *args, int num_arg);
extern spBool spSetObjectParams(spObject object, ...);
extern spBool spGetObjectParamsArg(spObject object, spArg *args, int num_arg);
extern spBool spGetObjectParams(spObject object, ...);
extern spBool spDestroyObject(spObject object);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPOBJECT_H */
