/*
 *	spParamField.h
 */

#ifndef __SPPARAMFIELD_H
#define __SPPARAMFIELD_H

#include <sp/spComponent.h>
#include <sp/spContainer.h>
#include <sp/spText.h>
#include <sp/spComboBox.h>
#include <sp/spSlider.h>
#include <sp/spDialog.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpParamField "ParamField"
    
#define SppFieldType "eFieldType"
#define SppFieldOffset "iFieldOffset"
#define SppFieldSize "iFieldSize"
#define SppFieldString SppTextString
#define SppFieldStrings SppListStrings
#define SppFieldSelectedIndex SppSelectedListIndex
#define SppDimension "SDimension"
#define SppDimensionSize "iDimensionSize"
#define SppDimention SppDimension /* spell miss */
#define SppDimentionSize SppDimensionSize /* spell miss */
#define SppUseCheckBox "bUseCheckBox"
#define SppUseDimensionButton "bUseDimensionButton"

/*
   SppInitialDir
   SppInitialFont
   SppInitialColor
   
   you must keep memory until destruction for the following parameters 
   SppFileFilters: 
   SppFileTypes
   SppFileFilterIndex
*/
    
typedef enum {
    SP_FIELD_TYPE_TEXT = 0,
    SP_FIELD_TYPE_COMBO_BOX = 1,
    SP_FIELD_TYPE_SPIN_BOX = 2,	/* not supported yet */
    SP_FIELD_TYPE_DIR_TEXT = 3,
    SP_FIELD_TYPE_OPEN_FILE_TEXT = 4,
    SP_FIELD_TYPE_SAVE_FILE_TEXT = 5,
    
    SP_FIELD_TYPE_COLOR_TEXT = 7,
    SP_FIELD_TYPE_FONT_TEXT = 8,
    
    SP_FIELD_TYPE_TRACK_BAR = 10,
    SP_FIELD_TYPE_TRACK_BAR_WITH_TEXT = 11,
    SP_FIELD_TYPE_TRACK_BAR_WITH_COMBO_BOX = 12,

    SP_FIELD_TYPE_PROGRESS_BAR = 15, /* 0.6.16+ */
} spFieldType;

#define SP_FIELD_TYPE_TEXT_STRING "0"
#define SP_FIELD_TYPE_COMBO_BOX_STRING "1"
#define SP_FIELD_TYPE_SPIN_BOX_STRING "2"
#define SP_FIELD_TYPE_DIR_TEXT_STRING "3"
#define SP_FIELD_TYPE_OPEN_FILE_TEXT_STRING "4"
#define SP_FIELD_TYPE_SAVE_FILE_TEXT_STRING "5"
#define SP_FIELD_TYPE_COLOR_TEXT_STRING "7"
#define SP_FIELD_TYPE_FONT_TEXT_STRING "8"
#define SP_FIELD_TYPE_TRACK_BAR_STRING "10"
#define SP_FIELD_TYPE_TRACK_BAR_WITH_TEXT_STRING "11"
#define SP_FIELD_TYPE_TRACK_BAR_WITH_COMBO_BOX_STRING "12"

typedef struct _spParamFieldRec *spParamField;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpParamFieldClass;
    
extern spBool spIsParamField(spComponent component);
extern spComponent spCreateParamField(spComponent parent, const char *name, int size, ...);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPPARAMFIELD_H */
