/*
 *	spPluginCanvas.h
 */

#ifndef __SPPLUGINCANVAS_H
#define __SPPLUGINCANVAS_H

#include <sp/spCanvas.h>
#include <sp/spDrawingPlugin.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpPluginCanvas "PluginCanvas"
    
#define SppPluginName "SPluginName"	/* CG */

typedef struct _spPluginCanvasRec *spPluginCanvas;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpPluginCanvasClass;
    
extern spBool spIsPluginCanvas(spComponent component);
extern spBool spIsPluginCanvasCreated(spComponent component);
extern spBool spIsPluginCanvasDrawable(spComponent component);
extern spBool spIsPluginCanvasDrawingStarted(spComponent component);
extern const char *spGetPluginCanvasName(spComponent component);
extern spComponent spCreatePluginCanvasArg(spComponent parent, const char *name, spArg *args, int num_arg);
extern spComponent spCreatePluginCanvas(spComponent parent, const char *name, ...);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPPLUGINCANVAS_H */
