/*
 *        spPrimitive.h
 */

#ifndef __SPPRIMITIVE_H
#define __SPPRIMITIVE_H

#include <sp/spComponent.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpPrimitive "Primitive"
    
typedef struct _spPrimitiveRec *spPrimitive;
typedef struct _spPrimitiveClassRec *spPrimitiveClass;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpPrimitiveClass;
    
extern spBool spIsPrimitive(spComponent component);
extern spBool spShowToolTip(spComponent component);

/* Version 0.6.11+ support multiple event callbacks
 * (previously, only one event callback per component is allowed). */    
extern spBool spAddEventCallback(spComponent component, spEventCallbackFunc call_func);
extern spBool spRemoveEventCallback(spComponent component, spEventCallbackFunc call_func);
extern spBool spPostUserEvent(spComponent component, spEventType event_type, void *call_data);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPPRIMITIVE_H */
