/*
 *	spProgressBar.h
 */

#ifndef __SPPROGRESSBAR_H
#define __SPPROGRESSBAR_H

#include <sp/spPrimitive.h>
#include <sp/spSlider.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpProgressBar "ProgressBar"
    
#define SppSegmentedProgressBar "bSegmentedProgressBar"	/* CG */
    
typedef struct _spProgressBarRec *spProgressBar;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpProgressBarClass;
    
extern spBool spIsProgressBar(spComponent component);
extern spComponent spCreateProgressBar(spComponent parent, const char *name, ...);
extern spBool spSetProgressBarValue(spComponent component, int value);
extern spBool spGetProgressBarValue(spComponent component, int *value);
extern spBool spIncrementProgressBar(spComponent component);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPPROGRESSBAR_H */
