/*
 *	spSlider.h
 */

#ifndef __SPSLIDER_H
#define __SPSLIDER_H

#include <sp/spPrimitive.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpSlider "Slider"
#define SpScrollBar "ScrollBar"
#define SpTrackBar "TrackBar"
#define SpUpDownButton "UpDownButton"
    
#define SppMinimum "iMinimum"	/* CSG */
#define SppMaximum "iMaximum"	/* CSG */
#define SppValue "iValue"	/* CSG */
#define SppIncrement "iIncrement" /* CSG */
#define SppPageIncrement "iPageIncrement" /* CSG */
#define SppPageSize "iPageSize"	/* CSG */
#define SppSliderSize "iPageSize" /* same as SppPageSize */
#define SppTrackCallbackOn "bTrackCallbackOn" /* CSG */
#define SppShowScale "bShowScale" /* CG */
#define SppShowValue "bShowValue" /* CG */
#define SppDecimalPoints "iDecimalPoints" /* CSG */
#define SppReversed "bReversed" /* CG */

/* version 0.6.14+ */
#define SppWheelIncrement "iWheelIncrement" /* CSG */
    
typedef struct _spSliderRec *spSlider;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpSliderClass;

extern spBool spIsSlider(spComponent component);
extern spBool spIsTrackBar(spComponent component); /* 0.6.14+ */
extern spBool spIsComponentTrackBar(spComponent component); /* 0.6.21-8+ */
extern spComponent spCreateScrollBar(spComponent parent, const char *name, ...);
extern spComponent spCreateTrackBar(spComponent parent, const char *name, ...);
extern spBool spSetSliderValue(spComponent component, int value);
extern spBool spGetSliderValue(spComponent component, int *value);
extern spBool spSetSliderDecimalValue(spComponent component, double value);
extern spBool spGetSliderDecimalValue(spComponent component, double *value);
extern int spGetScrollBarDefaultWidth(void);
extern int spGetTrackBarDefaultWidth(spOrientation orientation, spBool show_value);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPSLIDER_H */
