/*
 *	spStatusBar.h
 */

#ifndef __SPSTATUSBAR_H
#define __SPSTATUSBAR_H

#include <sp/spText.h>
#include <sp/spList.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpStatusBar "StatusBar"
    
#define SppUseLastItem "bUseLastItem"
#define SppItemSizes "PItemSizes"
#define SppDefaultItemIndex "iDefaultItemIndex"
#define SppHelpItemIndex "iHelpItemIndex"
    
typedef struct _spStatusBarRec *spStatusBar;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpStatusBarClass;
    
extern spBool spIsStatusBar(spComponent component);
extern spComponent spCreateStatusBar(spComponent parent, const char *name, ...);
extern spBool spSetStatusText(spComponent component, int index, const char *string);
extern spBool spSetHelpStatusText(spComponent component, const char *string);
extern spBool spSetDefaultStatusText(spComponent component, const char *string);
extern void spSetStatusTextCB(spComponent component, const char *string);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPSTATUSBAR_H */
