/*
 *	spStringDefs.h
 */

#ifndef __SPSTRINGDEFS_H
#define __SPSTRINGDEFS_H

#include <sp/spDefs.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(MACOS)
#pragma import on
#endif

extern const char *spGetString(const char *id);

#if defined(MACOS)
#pragma import off
#endif

typedef struct _spStringTable {
    char *id;
    char *string;
} spStringTable;

#define SP_NULL_ID NULL
#define SP_OK_LABEL_ID "SP_OK_LABEL"
#define SP_CANCEL_LABEL_ID "SP_CANCEL_LABEL"
#define SP_YES_LABEL_ID "SP_YES_LABEL"
#define SP_NO_LABEL_ID "SP_NO_LABEL"
#define SP_RETRY_LABEL_ID "SP_RETRY_LABEL"
#define SP_OPEN_LABEL_ID "SP_OPEN_LABEL"
#define SP_SAVE_LABEL_ID "SP_SAVE_LABEL"
#define SP_FILTER_LABEL_ID "SP_FILTER_LABEL"
#define SP_APPLY_LABEL_ID "SP_APPLY_LABEL"
#define SP_FILE_LIST_LABEL_ID "SP_FILE_LIST_LABEL"
#define SP_DIR_LIST_LABEL_ID "SP_DIR_LIST_LABEL"
#define SP_FILE_NAME_LABEL_ID "SP_FILE_NAME_LABEL"
#define SP_FILE_TYPE_LABEL_ID "SP_FILE_TYPE_LABEL"
    
#define SP_INFORMATION_TITLE_ID "SP_INFORMATION_TITLE"
#define SP_QUESTION_TITLE_ID "SP_QUESTION_TITLE"
#define SP_WARNING_TITLE_ID "SP_WARNING_TITLE"
#define SP_ERROR_TITLE_ID "SP_ERROR_TITLE"
#define SP_WORKING_TITLE_ID "SP_WORKING_TITLE"
#define SP_MESSAGE_TITLE_ID "SP_MESSAGE_TITLE"
#define SP_OPEN_TITLE_ID "SP_OPEN_TITLE"
#define SP_SAVE_TITLE_ID "SP_SAVE_TITLE"
#define SP_DIR_SELECTION_TITLE_ID "SP_DIR_SELECTION_TITLE"
#define SP_FILE_SELECTION_BUTTON_ID "SP_FILE_SELECTION_BUTTON"
#define SP_DIR_SELECTION_BUTTON_ID "SP_DIR_SELECTION_BUTTON"
#define SP_FONT_SELECTION_TITLE_ID "SP_FONT_SELECTION_TITLE"
#define SP_FONT_FAMILY_LABEL_ID "SP_FONT_FAMILY_LABEL"
#define SP_FONT_STYLE_LABEL_ID "SP_FONT_STYLE_LABEL"
#define SP_FONT_STYLE_MEDIUM_LABEL_ID "SP_FONT_STYLE_MEDIUM_LABEL"
#define SP_FONT_STYLE_ITALIC_LABEL_ID "SP_FONT_STYLE_ITALIC_LABEL"
#define SP_FONT_STYLE_OBLIQUE_LABEL_ID "SP_FONT_STYLE_OBLIQUE_LABEL"
#define SP_FONT_STYLE_BOLD_LABEL_ID "SP_FONT_STYLE_BOLD_LABEL"
#define SP_FONT_STYLE_BOLD_ITALIC_LABEL_ID "SP_FONT_STYLE_BOLD_ITALIC_LABEL"
#define SP_FONT_STYLE_BOLD_OBLIQUE_LABEL_ID "SP_FONT_STYLE_BOLD_OBLIQUE_LABEL"
#define SP_FONT_STYLE_LIGHT_LABEL_ID "SP_FONT_STYLE_LIGHT_LABEL"
#define SP_FONT_STYLE_LIGHT_ITALIC_LABEL_ID "SP_FONT_STYLE_LIGHT_ITALIC_LABEL"
#define SP_FONT_STYLE_LIGHT_OBLIQUE_LABEL_ID "SP_FONT_STYLE_LIGHT_OBLIQUE_LABEL"
#define SP_FONT_STYLE_BLACK_LABEL_ID "SP_FONT_STYLE_BLACK_LABEL"
#define SP_FONT_STYLE_BLACK_ITALIC_LABEL_ID "SP_FONT_STYLE_BLACK_ITALIC_LABEL"
#define SP_FONT_STYLE_BLACK_OBLIQUE_LABEL_ID "SP_FONT_STYLE_BLACK_OBLIQUE_LABEL"
#define SP_FONT_SIZE_LABEL_ID "SP_FONT_SIZE_LABEL"
#define SP_FONT_CHARSET_LABEL_ID "SP_FONT_CHARSET_LABEL"
#define SP_FONT_SAMPLE_LABEL_ID "SP_FONT_SAMPLE_LABEL"
#define SP_FONT_SAMPLE_CONTENTS_C_ID "SP_FONT_SAMPLE_CONTENTS_C"
#define SP_FONT_SAMPLE_CONTENTS_ID "SP_FONT_SAMPLE_CONTENTS"
#define SP_COLOR_SELECTION_TITLE_ID "SP_COLOR_SELECTION_TITLE"
#define SP_PAGE_SETUP_TITLE_ID "SP_PAGE_SETUP_PAPER_TITLE"
#define SP_PAGE_SETUP_PAPER_TITLE_ID "SP_PAGE_SETUP_PAPER_TITLE"
#define SP_PAGE_SETUP_PAPER_TYPE_ID "SP_PAGE_SETUP_PAPER_TYPE"
#define SP_PAGE_SETUP_PAPER_SIZE_ID "SP_PAGE_SETUP_PAPER_SIZE"
#define SP_PAGE_SETUP_ORIENTATION_TITLE_ID "SP_PAGE_SETUP_ORIENTATION_TITLE"
#define SP_PAGE_SETUP_ORIENTATION_PORTRAIT_ID "SP_PAGE_SETUP_ORIENTATION_PORTRAIT"
#define SP_PAGE_SETUP_ORIENTATION_LANDSCAPE_ID "SP_PAGE_SETUP_ORIENTATION_LANDSCAPE"
#define SP_PAGE_SETUP_MARGIN_TITLE_ID "SP_PAGE_SETUP_MARGIN_TITLE"
#define SP_PAGE_SETUP_MARGIN_LEFT_LABEL_ID "SP_PAGE_SETUP_MARGIN_LEFT_LABEL"
#define SP_PAGE_SETUP_MARGIN_RIGHT_LABEL_ID "SP_PAGE_SETUP_MARGIN_RIGHT_LABEL"
#define SP_PAGE_SETUP_MARGIN_TOP_LABEL_ID "SP_PAGE_SETUP_MARGIN_TOP_LABEL"
#define SP_PAGE_SETUP_MARGIN_BOTTOM_LABEL_ID "SP_PAGE_SETUP_MARGIN_BOTTOM_LABEL"
#define SP_PAGE_SETUP_PREVIEW_TITLE_ID "SP_PAGE_SETUP_PREVIEW_TITLE"
#define SP_PAGE_SETUP_MARGIN_WARNING_TITLE_ID "SP_PAGE_SETUP_MARGIN_WARNING_TITLE"
#define SP_PAGE_SETUP_MARGIN_WARNING_MESSAGE_ID "SP_PAGE_SETUP_MARGIN_WARNING_MESSAGE"
#define SP_PRINTER_DIALOG_TITLE_ID "SP_PRINTER_DIALOG_TITLE"
#define SP_PRINTER_BOX_TITLE_ID "SP_PRINTER_BOX_TITLE"
#define SP_PRINTER_NAME_LABEL_ID "SP_PRINTER_NAME_LABEL"
#define SP_PRINT_RANGE_BOX_TITLE_ID "SP_PRINT_RANGE_BOX_TITLE"
#define SP_PRINT_RANGE_ALL_LABEL_ID "SP_PRINT_RANGE_ALL_LABEL"
#define SP_PRINT_RANGE_SELECTION_LABEL_ID "SP_PRINT_RANGE_SELECTION_LABEL"
#define SP_PRINT_RANGE_CURRENT_LABEL_ID "SP_PRINT_RANGE_CURRENT_LABEL"
#define SP_PRINT_RANGE_PAGES_LABEL_ID "SP_PRINT_RANGE_PAGES_LABEL"
#define SP_PRINT_COPIES_BOX_TITLE_ID "SP_PRINT_COPIES_BOX_TITLE"
#define SP_PRINT_COPIES_FIELD_LABEL_ID "SP_PRINT_COPIES_FIELD_LABEL"
#define SP_PRINT_COLLATE_LABEL_ID "SP_PRINT_COLLATE_LABEL"
#define SP_PRINT_RANGE_FROM_LABEL_ID "SP_PRINT_RANGE_FROM_LABEL"
#define SP_PRINT_RANGE_TO_LABEL_ID "SP_PRINT_RANGE_TO_LABEL"
#define SP_PRINT_DOUBLE_SIDED_LABEL_ID "SP_PRINT_DOUBLE_SIDED_LABEL"
#define SP_PRINT_DOUBLE_SIDED_TUMBLE_LABEL_ID "SP_PRINT_DOUBLE_SIDED_TUMBLE_LABEL"
#define SP_PRINT_WARNING_TITLE_ID "SP_PRINT_WARNING_TITLE"
#define SP_PRINT_RANGE_WARNING_MESSAGE_ID "SP_PRINT_RANGE_WARNING_MESSAGE"

#define SP_QUIT_QUESTION_TITLE_ID "SP_QUIT_QUESTION_TITLE"
#define SP_QUIT_QUESTION_MESSAGE_ID "SP_QUIT_QUESTION_MESSAGE"
#define SP_CLOSE_QUESTION_TITLE_ID "SP_CLOSE_QUESTION_TITLE"
#define SP_CLOSE_QUESTION_MESSAGE_ID "SP_CLOSE_QUESTION_MESSAGE"
#define SP_MODIFY_QUIT_QUESTION_TITLE_ID "SP_MODIFY_QUIT_QUESTION_TITLE"
#define SP_MODIFY_QUIT_QUESTION_MESSAGE_ID "SP_MODIFY_QUIT_QUESTION_MESSAGE"
#define SP_MODIFY_CLOSE_QUESTION_TITLE_ID "SP_MODIFY_CLOSE_QUESTION_TITLE"
#define SP_MODIFY_CLOSE_QUESTION_MESSAGE_ID "SP_MODIFY_CLOSE_QUESTION_MESSAGE"
#define SP_OVERWRITE_PROMPT_TITLE_ID "SP_OVERWRITE_PROMPT_TITLE"
#define SP_OVERWRITE_PROMPT_MESSAGE_ID "SP_OVERWRITE_PROMPT_MESSAGE"
#define SP_SAVE_CHANGES_PROMPT_TITLE_ID "SP_SAVE_CHANGES_PROMPT_TITLE"
#define SP_SAVE_CHANGES_PROMPT_MESSAGE_ID "SP_SAVE_CHANGES_PROMPT_MESSAGE"
#define SP_NOT_FOUND_FILE_MESSAGE_ID "SP_NOT_FOUND_FILE_MESSAGE"
#define SP_NOT_FOUND_PATH_MESSAGE_ID "SP_NOT_FOUND_PATH_MESSAGE"
#define SP_NOT_DIR_MESSAGE_ID "SP_NOT_DIR_MESSAGE"

#define SP_FILE_MENU_LABEL_ID "SP_FILE_MENU_LABEL"
#define SP_EDIT_MENU_LABEL_ID "SP_EDIT_MENU_LABEL"
#define SP_VIEW_MENU_LABEL_ID "SP_VIEW_MENU_LABEL"
#define SP_WINDOW_MENU_LABEL_ID "SP_WINDOW_MENU_LABEL"
#define SP_HELP_MENU_LABEL_ID "SP_HELP_MENU_LABEL"
#define SP_HELP_WITH_NAME_MENU_LABEL_ID "SP_HELP_WITH_NAME_MENU_LABEL"

#define SP_NEW_MENU_LABEL_ID "SP_NEW_MENU_LABEL"
#define SP_OPEN_MENU_LABEL_ID "SP_OPEN_MENU_LABEL"
#define SP_CLOSE_MENU_LABEL_ID "SP_CLOSE_MENU_LABEL"
#define SP_SAVE_MENU_LABEL_ID "SP_SAVE_MENU_LABEL"
#define SP_SAVE_AS_MENU_LABEL_ID "SP_SAVE_AS_MENU_LABEL"
#define SP_PAGE_SETUP_MENU_LABEL_ID "SP_PAGE_SETUP_MENU_LABEL"
#define SP_PRINT_MENU_LABEL_ID "SP_PRINT_MENU_LABEL"
#define SP_QUIT_MENU_LABEL_ID "SP_QUIT_MENU_LABEL"
#define SP_QUIT_WITH_NAME_MENU_LABEL_ID "SP_QUIT_WITH_NAME_MENU_LABEL"

#define SP_UNDO_MENU_LABEL_ID "SP_UNDO_MENU_LABEL"
#define SP_REDO_MENU_LABEL_ID "SP_REDO_MENU_LABEL"
#define SP_CUT_MENU_LABEL_ID "SP_CUT_MENU_LABEL"
#define SP_COPY_MENU_LABEL_ID "SP_COPY_MENU_LABEL"
#define SP_PASTE_MENU_LABEL_ID "SP_PASTE_MENU_LABEL"
#define SP_CLEAR_MENU_LABEL_ID "SP_CLEAR_MENU_LABEL"
#define SP_DELETE_MENU_LABEL_ID "SP_DELETE_MENU_LABEL"
#define SP_SELECT_ALL_MENU_LABEL_ID "SP_SELECT_ALL_MENU_LABEL"

#define SP_ABOUT_MENU_LABEL_ID "SP_ABOUT_MENU_LABEL"
#define SP_ABOUT_WITH_NAME_MENU_LABEL_ID "SP_ABOUT_WITH_NAME_MENU_LABEL"
#define SP_ABOUT_LABEL_ID "SP_ABOUT_LABEL"
#define SP_THIS_SOFTWARE_LABEL_ID "SP_THIS_SOFTWARE_LABEL"

#define SP_PREFERENCE_MENU_LABEL_ID "SP_PREFERENCE_MENU_LABEL"
#define SP_SERVICES_MENU_LABEL_ID "SP_SERVICES_MENU_LABEL"
#define SP_HIDE_WITH_NAME_MENU_LABEL_ID "SP_HIDE_WITH_NAME_MENU_LABEL"
#define SP_HIDE_OTHERS_MENU_LABEL_ID "SP_HIDE_OTHERS_MENU_LABEL"
#define SP_SHOW_ALL_MENU_LABEL_ID "SP_SHOW_ALL_MENU_LABEL"
    
#define SP_MINIMIZE_MENU_LABEL_ID "SP_MINIMIZE_MENU_LABEL"
#define SP_ZOOM_MENU_LABEL_ID "SP_ZOOM_MENU_LABEL"
#define SP_BRING_ALL_TO_FRONT_MENU_LABEL_ID "SP_BRING_ALL_TO_FRONT_MENU_LABEL"

    
#define SP_OK_LABEL spGetString(SP_OK_LABEL_ID)
#define SP_CANCEL_LABEL spGetString(SP_CANCEL_LABEL_ID)
#define SP_YES_LABEL spGetString(SP_YES_LABEL_ID)
#define SP_NO_LABEL spGetString(SP_NO_LABEL_ID)
#define SP_RETRY_LABEL spGetString(SP_RETRY_LABEL_ID)
#define SP_OPEN_LABEL spGetString(SP_OPEN_LABEL_ID)
#define SP_SAVE_LABEL spGetString(SP_SAVE_LABEL_ID)
#define SP_FILTER_LABEL spGetString(SP_FILTER_LABEL_ID)
#define SP_APPLY_LABEL spGetString(SP_APPLY_LABEL_ID)
#define SP_FILE_LIST_LABEL spGetString(SP_FILE_LIST_LABEL_ID)
#define SP_DIR_LIST_LABEL spGetString(SP_DIR_LIST_LABEL_ID)
#define SP_FILE_NAME_LABEL spGetString(SP_FILE_NAME_LABEL_ID)
#define SP_FILE_TYPE_LABEL spGetString(SP_FILE_TYPE_LABEL_ID)

#define SP_INFORMATION_TITLE spGetString(SP_INFORMATION_TITLE_ID)
#define SP_QUESTION_TITLE spGetString(SP_QUESTION_TITLE_ID)
#define SP_WARNING_TITLE spGetString(SP_WARNING_TITLE_ID)
#define SP_ERROR_TITLE spGetString(SP_ERROR_TITLE_ID)
#define SP_WORKING_TITLE spGetString(SP_WORKING_TITLE_ID)
#define SP_MESSAGE_TITLE spGetString(SP_MESSAGE_TITLE_ID)
#define SP_OPEN_TITLE spGetString(SP_OPEN_TITLE_ID)
#define SP_SAVE_TITLE spGetString(SP_SAVE_TITLE_ID)
#define SP_DIR_SELECTION_TITLE spGetString(SP_DIR_SELECTION_TITLE_ID)
#define SP_FILE_SELECTION_BUTTON spGetString(SP_FILE_SELECTION_BUTTON_ID)
#define SP_DIR_SELECTION_BUTTON spGetString(SP_DIR_SELECTION_BUTTON_ID)
#define SP_FONT_SELECTION_TITLE spGetString(SP_FONT_SELECTION_TITLE_ID)
#define SP_FONT_FAMILY_LABEL spGetString(SP_FONT_FAMILY_LABEL_ID)
#define SP_FONT_STYLE_LABEL spGetString(SP_FONT_STYLE_LABEL_ID)
#define SP_FONT_STYLE_MEDIUM_LABEL spGetString(SP_FONT_STYLE_MEDIUM_LABEL_ID)
#define SP_FONT_STYLE_ITALIC_LABEL spGetString(SP_FONT_STYLE_ITALIC_LABEL_ID)
#define SP_FONT_STYLE_OBLIQUE_LABEL spGetString(SP_FONT_STYLE_OBLIQUE_LABEL_ID)
#define SP_FONT_STYLE_BOLD_LABEL spGetString(SP_FONT_STYLE_BOLD_LABEL_ID)
#define SP_FONT_STYLE_BOLD_ITALIC_LABEL spGetString(SP_FONT_STYLE_BOLD_ITALIC_LABEL_ID)
#define SP_FONT_STYLE_BOLD_OBLIQUE_LABEL spGetString(SP_FONT_STYLE_BOLD_OBLIQUE_LABEL_ID)
#define SP_FONT_STYLE_LIGHT_LABEL spGetString(SP_FONT_STYLE_LIGHT_LABEL_ID)
#define SP_FONT_STYLE_LIGHT_ITALIC_LABEL spGetString(SP_FONT_STYLE_LIGHT_ITALIC_LABEL_ID)
#define SP_FONT_STYLE_LIGHT_OBLIQUE_LABEL spGetString(SP_FONT_STYLE_LIGHT_OBLIQUE_LABEL_ID)
#define SP_FONT_STYLE_BLACK_LABEL spGetString(SP_FONT_STYLE_BLACK_LABEL_ID)
#define SP_FONT_STYLE_BLACK_ITALIC_LABEL spGetString(SP_FONT_STYLE_BLACK_ITALIC_LABEL_ID)
#define SP_FONT_STYLE_BLACK_OBLIQUE_LABEL spGetString(SP_FONT_STYLE_BLACK_OBLIQUE_LABEL_ID)
#define SP_FONT_SIZE_LABEL spGetString(SP_FONT_SIZE_LABEL_ID)
#define SP_FONT_CHARSET_LABEL spGetString(SP_FONT_CHARSET_LABEL_ID)
#define SP_FONT_SAMPLE_LABEL spGetString(SP_FONT_SAMPLE_LABEL_ID)
#define SP_FONT_SAMPLE_CONTENTS_C spGetString(SP_FONT_SAMPLE_CONTENTS_C_ID)
#define SP_FONT_SAMPLE_CONTENTS spGetString(SP_FONT_SAMPLE_CONTENTS_ID)
#define SP_COLOR_SELECTION_TITLE spGetString(SP_COLOR_SELECTION_TITLE_ID)
#define SP_PAGE_SETUP_TITLE spGetString(SP_PAGE_SETUP_PAPER_TITLE_ID)
#define SP_PAGE_SETUP_PAPER_TITLE spGetString(SP_PAGE_SETUP_PAPER_TITLE_ID)
#define SP_PAGE_SETUP_PAPER_TYPE spGetString(SP_PAGE_SETUP_PAPER_TYPE_ID)
#define SP_PAGE_SETUP_PAPER_SIZE spGetString(SP_PAGE_SETUP_PAPER_SIZE_ID)
#define SP_PAGE_SETUP_ORIENTATION_TITLE spGetString(SP_PAGE_SETUP_ORIENTATION_TITLE_ID)
#define SP_PAGE_SETUP_ORIENTATION_PORTRAIT spGetString(SP_PAGE_SETUP_ORIENTATION_PORTRAIT_ID)
#define SP_PAGE_SETUP_ORIENTATION_LANDSCAPE spGetString(SP_PAGE_SETUP_ORIENTATION_LANDSCAPE_ID)
#define SP_PAGE_SETUP_MARGIN_TITLE spGetString(SP_PAGE_SETUP_MARGIN_TITLE_ID)
#define SP_PAGE_SETUP_MARGIN_LEFT_LABEL spGetString(SP_PAGE_SETUP_MARGIN_LEFT_LABEL_ID)
#define SP_PAGE_SETUP_MARGIN_RIGHT_LABEL spGetString(SP_PAGE_SETUP_MARGIN_RIGHT_LABEL_ID)
#define SP_PAGE_SETUP_MARGIN_TOP_LABEL spGetString(SP_PAGE_SETUP_MARGIN_TOP_LABEL_ID)
#define SP_PAGE_SETUP_MARGIN_BOTTOM_LABEL spGetString(SP_PAGE_SETUP_MARGIN_BOTTOM_LABEL_ID)
#define SP_PAGE_SETUP_PREVIEW_TITLE spGetString(SP_PAGE_SETUP_PREVIEW_TITLE_ID)
#define SP_PAGE_SETUP_MARGIN_WARNING_TITLE spGetString(SP_PAGE_SETUP_MARGIN_WARNING_TITLE_ID)
#define SP_PAGE_SETUP_MARGIN_WARNING_MESSAGE spGetString(SP_PAGE_SETUP_MARGIN_WARNING_MESSAGE_ID)
#define SP_PRINTER_DIALOG_TITLE spGetString(SP_PRINTER_DIALOG_TITLE_ID)
#define SP_PRINTER_BOX_TITLE spGetString(SP_PRINTER_BOX_TITLE_ID)
#define SP_PRINTER_NAME_LABEL spGetString(SP_PRINTER_NAME_LABEL_ID)
#define SP_PRINT_RANGE_BOX_TITLE spGetString(SP_PRINT_RANGE_BOX_TITLE_ID)
#define SP_PRINT_RANGE_ALL_LABEL spGetString(SP_PRINT_RANGE_ALL_LABEL_ID)
#define SP_PRINT_RANGE_SELECTION_LABEL spGetString(SP_PRINT_RANGE_SELECTION_LABEL_ID)
#define SP_PRINT_RANGE_CURRENT_LABEL spGetString(SP_PRINT_RANGE_CURRENT_LABEL_ID)
#define SP_PRINT_RANGE_PAGES_LABEL spGetString(SP_PRINT_RANGE_PAGES_LABEL_ID)
#define SP_PRINT_COPIES_BOX_TITLE spGetString(SP_PRINT_COPIES_BOX_TITLE_ID)
#define SP_PRINT_COPIES_FIELD_LABEL spGetString(SP_PRINT_COPIES_FIELD_LABEL_ID)
#define SP_PRINT_COLLATE_LABEL spGetString(SP_PRINT_COLLATE_LABEL_ID)
#define SP_PRINT_RANGE_FROM_LABEL spGetString(SP_PRINT_RANGE_FROM_LABEL_ID)
#define SP_PRINT_RANGE_TO_LABEL spGetString(SP_PRINT_RANGE_TO_LABEL_ID)
#define SP_PRINT_DOUBLE_SIDED_LABEL spGetString(SP_PRINT_DOUBLE_SIDED_LABEL_ID)
#define SP_PRINT_DOUBLE_SIDED_TUMBLE_LABEL spGetString(SP_PRINT_DOUBLE_SIDED_TUMBLE_LABEL_ID)
#define SP_PRINT_WARNING_TITLE spGetString(SP_PRINT_WARNING_TITLE_ID)
#define SP_PRINT_RANGE_WARNING_MESSAGE spGetString(SP_PRINT_RANGE_WARNING_MESSAGE_ID)
    
#define SP_QUIT_QUESTION_TITLE spGetString(SP_QUIT_QUESTION_TITLE_ID)
#define SP_QUIT_QUESTION_MESSAGE  spGetString(SP_QUIT_QUESTION_MESSAGE_ID)
#define SP_CLOSE_QUESTION_TITLE spGetString(SP_CLOSE_QUESTION_TITLE_ID)
#define SP_CLOSE_QUESTION_MESSAGE spGetString(SP_CLOSE_QUESTION_MESSAGE_ID)
#define SP_MODIFY_QUIT_QUESTION_TITLE spGetString(SP_MODIFY_QUIT_QUESTION_TITLE_ID)
#define SP_MODIFY_QUIT_QUESTION_MESSAGE spGetString(SP_MODIFY_QUIT_QUESTION_MESSAGE_ID)
#define SP_MODIFY_CLOSE_QUESTION_TITLE spGetString(SP_MODIFY_CLOSE_QUESTION_TITLE_ID)
#define SP_MODIFY_CLOSE_QUESTION_MESSAGE spGetString(SP_MODIFY_CLOSE_QUESTION_MESSAGE_ID)
#define SP_OVERWRITE_PROMPT_TITLE spGetString(SP_OVERWRITE_PROMPT_TITLE_ID)
#define SP_OVERWRITE_PROMPT_MESSAGE spGetString(SP_OVERWRITE_PROMPT_MESSAGE_ID)
#define SP_SAVE_CHANGES_PROMPT_TITLE spGetString(SP_SAVE_CHANGES_PROMPT_TITLE_ID)
#define SP_SAVE_CHANGES_PROMPT_MESSAGE spGetString(SP_SAVE_CHANGES_PROMPT_MESSAGE_ID)
#define SP_NOT_FOUND_FILE_MESSAGE spGetString(SP_NOT_FOUND_FILE_MESSAGE_ID)
#define SP_NOT_FOUND_PATH_MESSAGE spGetString(SP_NOT_FOUND_PATH_MESSAGE_ID)
#define SP_NOT_DIR_MESSAGE spGetString(SP_NOT_DIR_MESSAGE_ID)

#define SP_FILE_MENU_LABEL spGetString(SP_FILE_MENU_LABEL_ID)
#define SP_EDIT_MENU_LABEL spGetString(SP_EDIT_MENU_LABEL_ID)
#define SP_VIEW_MENU_LABEL spGetString(SP_VIEW_MENU_LABEL_ID)
#define SP_WINDOW_MENU_LABEL spGetString(SP_WINDOW_MENU_LABEL_ID)
#define SP_HELP_MENU_LABEL spGetString(SP_HELP_MENU_LABEL_ID)
#define SP_HELP_WITH_NAME_MENU_LABEL spGetString(SP_HELP_WITH_NAME_MENU_LABEL_ID)

#define SP_NEW_MENU_LABEL spGetString(SP_NEW_MENU_LABEL_ID)
#define SP_OPEN_MENU_LABEL spGetString(SP_OPEN_MENU_LABEL_ID)
#define SP_CLOSE_MENU_LABEL spGetString(SP_CLOSE_MENU_LABEL_ID)
#define SP_SAVE_MENU_LABEL spGetString(SP_SAVE_MENU_LABEL_ID)
#define SP_SAVE_AS_MENU_LABEL spGetString(SP_SAVE_AS_MENU_LABEL_ID)
#define SP_PAGE_SETUP_MENU_LABEL spGetString(SP_PAGE_SETUP_MENU_LABEL_ID)
#define SP_PRINT_MENU_LABEL spGetString(SP_PRINT_MENU_LABEL_ID)
#define SP_QUIT_MENU_LABEL spGetString(SP_QUIT_MENU_LABEL_ID)
#define SP_QUIT_WITH_NAME_MENU_LABEL spGetString(SP_QUIT_WITH_NAME_MENU_LABEL_ID)

#define SP_UNDO_MENU_LABEL spGetString(SP_UNDO_MENU_LABEL_ID)
#define SP_REDO_MENU_LABEL spGetString(SP_REDO_MENU_LABEL_ID)
#define SP_CUT_MENU_LABEL spGetString(SP_CUT_MENU_LABEL_ID)
#define SP_COPY_MENU_LABEL spGetString(SP_COPY_MENU_LABEL_ID)
#define SP_PASTE_MENU_LABEL spGetString(SP_PASTE_MENU_LABEL_ID)
#define SP_CLEAR_MENU_LABEL spGetString(SP_CLEAR_MENU_LABEL_ID)
#define SP_DELETE_MENU_LABEL spGetString(SP_DELETE_MENU_LABEL_ID)
#define SP_SELECT_ALL_MENU_LABEL spGetString(SP_SELECT_ALL_MENU_LABEL_ID)

#define SP_ABOUT_MENU_LABEL spGetString(SP_ABOUT_MENU_LABEL_ID)
#define SP_ABOUT_WITH_NAME_MENU_LABEL spGetString(SP_ABOUT_WITH_NAME_MENU_LABEL_ID)
#define SP_ABOUT_LABEL spGetString(SP_ABOUT_LABEL_ID)
#define SP_THIS_SOFTWARE_LABEL spGetString(SP_THIS_SOFTWARE_LABEL_ID)

#define SP_PREFERENCE_MENU_LABEL spGetString(SP_PREFERENCE_MENU_LABEL_ID)
#define SP_SERVICES_MENU_LABEL spGetString(SP_SERVICES_MENU_LABEL_ID)
#define SP_HIDE_WITH_NAME_MENU_LABEL spGetString(SP_HIDE_WITH_NAME_MENU_LABEL_ID)
#define SP_HIDE_OTHERS_MENU_LABEL spGetString(SP_HIDE_OTHERS_MENU_LABEL_ID)
#define SP_SHOW_ALL_MENU_LABEL spGetString(SP_SHOW_ALL_MENU_LABEL_ID)
    
#define SP_MINIMIZE_MENU_LABEL spGetString(SP_MINIMIZE_MENU_LABEL_ID)
#define SP_ZOOM_MENU_LABEL spGetString(SP_ZOOM_MENU_LABEL_ID)
#define SP_BRING_ALL_TO_FRONT_MENU_LABEL spGetString(SP_BRING_ALL_TO_FRONT_MENU_LABEL_ID)

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPSTRINGDEFS_H */
