/*
 *	spTabBox.h
 */

#ifndef __SPTABBOX_H
#define __SPTABBOX_H

#include <sp/spText.h>
#include <sp/spList.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpTabBox "TabBox"
    
#define SppSelectedTabIndex "iSelectedTabIndex"
    
/* internal parameter */
#define SppTabItemIndex "iTabItemIndex"	/* C */
    
typedef struct _spTabBoxRec *spTabBox;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpTabBoxClass;
    
extern spBool spIsTabBox(spComponent component);
extern spComponent spCreateTabBox(spComponent parent, const char *name, int size, ...);
extern spBool spIsTabItem(spComponent component);
extern int spGetSelectedTabIndex(spComponent component);
extern spComponent spGetSelectedTabItem(spComponent component);
extern spComponent spAddTabItem(spComponent parent, const char *name, int index, ...);
    
/* 0.6.14+ */
extern spComponent spGetAncestorTabBox(spComponent component);
extern spBool spIsTabBoxChild(spComponent component);
extern spComponent spGetAncestorTabItem(spComponent component);

/* 0.6.21+, internal use only */
extern spComponent spCreateTabItemArg(spComponent parent, const char *name, spArg *args, int num_arg);
extern int spUpdateTabBoxToAdd(spComponent component, int index, spBool *visible);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPTABBOX_H */
