/*
 *	spText.h
 */

#ifndef __SPTEXT_H
#define __SPTEXT_H

#include <sp/spPrimitive.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpText "Text"
#define SpTextArea "TextArea"
#define SpTextField "TextField"
    
#define SppTextString "STextString" /* CSG */
#define SppEditable "bEditable"	/* CSG */
#define SppColumns "iColumns"	/* CG */
#define SppRows "iRows"		/* CG */
    
/* 0.6.6+ */
#define SppDisableShortcut "bDisableShortcut"	/* CSG */

/* 0.6.18+ */
#define SppKeyboardType "eKeyboardType"

typedef enum {
    SP_KEYBOARD_TYPE_UNKNOWN = -1,
    SP_KEYBOARD_TYPE_DEFAULT = 0,
    SP_KEYBOARD_TYPE_ALPHABET = 1,
    SP_KEYBOARD_TYPE_URL = 3,
    SP_KEYBOARD_TYPE_NUMBER_PAD = 4,
    SP_KEYBOARD_TYPE_PHONE_PAD = 5,
    SP_KEYBOARD_TYPE_EMAIL = 7,
    SP_KEYBOARD_TYPE_PASSWORD = 16,
    SP_KEYBOARD_TYPE_IP_ADDRESS = 17,
    SP_KEYBOARD_TYPE_DATETIME = 18,
} spKeyboardType;

#define SP_KEYBOARD_TYPE_UNKNOWN_STRING "-1"
#define SP_KEYBOARD_TYPE_DEFAULT_STRING "0"
#define SP_KEYBOARD_TYPE_ALPHABET_STRING "1"
#define SP_KEYBOARD_TYPE_URL_STRING "3"
#define SP_KEYBOARD_TYPE_NUMBER_PAD_STRING "4"
#define SP_KEYBOARD_TYPE_PHONE_PAD_STRING "5"
#define SP_KEYBOARD_TYPE_EMAIL_STRING "7"
#define SP_KEYBOARD_TYPE_PASSWORD_STRING "16"
#define SP_KEYBOARD_TYPE_IP_ADDRESS_STRING "17"
#define SP_KEYBOARD_TYPE_DATETIME_STRING "18"


typedef struct _spTextRec *spText;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpTextClass;

extern spBool spIsText(spComponent component);
extern spBool spIsTextField(spComponent component); /* 0.6.14+ */
extern spBool spIsComponentTextField(spComponent component); /* 0.6.21-8+ */
extern spBool spIsTextArea(spComponent component); /* 0.6.19+ */
extern spBool spIsEditable(spComponent component);
extern spComponent spCreateTextField(spComponent parent, const char *name, ...);
extern spComponent spCreateTextArea(spComponent parent, const char *name, ...);
extern spBool spSetTextString(spComponent component, const char *string);
extern const char *spGetTextString(spComponent component);
extern char *xspGetTextString(spComponent component);

/* Version 0.6.5+ */
/* if start == -1, a selection is deselected (end is ignored).
   if end == -1, remaining text is selected. */
extern spBool spSetTextSelection(spComponent component, long start, long end);
/* if no selection, this returns SP_FALSE. */
extern spBool spGetTextSelection(spComponent component, long *start, long *end);
/* selection will be cleared by this function */
extern spBool spSetTextPosition(spComponent component, long position);
extern spBool spGetTextPosition(spComponent component, long *position);

extern spBool spCutText(spComponent component);
extern spBool spCopyText(spComponent component);
extern spBool spPasteText(spComponent component);
extern spBool spClearText(spComponent component);
extern spBool spSelectAllText(spComponent component);

extern void spCutTextCB(spComponent component, void *data);
extern void spCopyTextCB(spComponent component, void *data);
extern void spPasteTextCB(spComponent component, void *data);
extern void spClearTextCB(spComponent component, void *data);
extern void spSelectAllTextCB(spComponent component, void *data);
extern void spSelectAllTextCB(spComponent component, void *data);

extern int spGetTextFieldDefaultHeight(spBool margin_flag);
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPTEXT_H */
