/*
 *	spToolBar.h
 */

#ifndef __SPTOOLBAR_H
#define __SPTOOLBAR_H

#include <sp/spPrimitive.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpToolBar "ToolBar"
    
#define SppNumBitmap "iNumBitmap"
#define SppBitmapWidth "iBitmapWidth"
#define SppBitmapHeight "iBitmapHeight"
#define SppBitmapPathEnv "SBitmapPathEnv"
#define SppBitmapData "LBitmapData"

/* 0.6.14+ */    
#define SppToolBarGroupIndex "iToolBarGroupIndex"
    
typedef struct _spToolBarRec *spToolBar;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpToolBarClass;
    
extern spBool spIsToolBar(spComponent component);
extern spComponent spCreateToolBar(spComponent parent, const char *name, int num_item, ...);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPTOOLBAR_H */
