/*
 *	spToolItem.h
 */

#ifndef __SPTOOLITEM_H
#define __SPTOOLITEM_H

#include <sp/spPrimitive.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpToolItem "ToolItem"
#define SpCheckToolItem "CheckToolItem"
#define SpToolSeparator "ToolSeparator"
    
#define SppBitmapIndex "iBitmapIndex"

/* 0.6.18+ */
#define SppToolItemPrint "bToolItemPrint"	/* CG */
    
typedef struct _spToolItemRec *spToolItem;

#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpToolItemClass;
    
extern spBool spIsToolItem(spComponent component);
extern spBool spIsCheckToolItem(spComponent component);
extern spComponent spAddToolItem(spComponent parent, const char *name, ...);
extern spComponent spAddCheckToolItem(spComponent parent, const char *name, ...);
extern spComponent spAddToolSeparator(spComponent parent, const char *name, ...);
extern spBool spSetToolItemToggleState(spComponent component, spBool set);
extern spBool spGetToolItemToggleState(spComponent component, spBool *set);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPTOOLITEM_H */
